/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer;

import figtree.treeviewer.decorators.DiscreteColourDecorator;
import figtree.treeviewer.decorators.FixedDiscreteColourDecorator;
import figtree.treeviewer.decorators.HSBDiscreteColourDecorator;
import figtree.ui.components.RangeSlider;
import jam.panels.OptionsPanel;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class DiscreteColourScaleDialog {
    private static final int SLIDER_RANGE = 1000;
    private static final String HSB_SPECTRUM = "HSB Spectrum";
    private static final String FIXED_COLOURS = "Fixed Colours";
    private JFrame frame;
    private JComboBox colourSchemeCombo = new JComboBox<String>(new String[]{"HSB Spectrum", "Fixed Colours"});
    CardLayout cardLayout = new CardLayout();
    private final JPanel colourSchemePanel;
    private Map<String, ColourSchemePanel> colourSchemeNamePanelMap = new HashMap<String, ColourSchemePanel>();
    private Map<Class, String> colourSchemeClassNameMap = new HashMap<Class, String>();
    private List<Object> discreteValues = null;
    private JTable table;
    private ColourTableModel tableModel;
    private JDialog dialog;

    public DiscreteColourScaleDialog(JFrame jFrame) {
        this.frame = jFrame;
        this.colourSchemeNamePanelMap.put(HSB_SPECTRUM, new HSBColourSchemePanel());
        this.colourSchemeNamePanelMap.put(FIXED_COLOURS, new FixedColourSchemePanel());
        this.colourSchemeClassNameMap.put(HSBDiscreteColourDecorator.class, HSB_SPECTRUM);
        this.colourSchemeClassNameMap.put(FixedDiscreteColourDecorator.class, FIXED_COLOURS);
        this.colourSchemePanel = new JPanel(this.cardLayout);
        for (String string : this.colourSchemeNamePanelMap.keySet()) {
            ColourSchemePanel colourSchemePanel = this.colourSchemeNamePanelMap.get(string);
            this.colourSchemePanel.add((Component)colourSchemePanel.getPanel(), string);
        }
        this.colourSchemeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DiscreteColourScaleDialog.this.cardLayout.show(DiscreteColourScaleDialog.this.colourSchemePanel, DiscreteColourScaleDialog.this.colourSchemeCombo.getSelectedItem().toString());
                DiscreteColourScaleDialog.this.tableModel.fireTableDataChanged();
                DiscreteColourScaleDialog.this.dialog.pack();
            }
        });
        this.tableModel = new ColourTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setDefaultRenderer(Color.class, new ColorRenderer(true));
        this.table.setDefaultRenderer(Paint.class, new ColorRenderer(true));
        this.table.setDragEnabled(true);
        this.table.setDropMode(DropMode.INSERT_ROWS);
        this.table.setTransferHandler(new TableRowTransferHandler(this.table));
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.getColumnModel().getColumn(1).setWidth(80);
        this.table.getColumnModel().getColumn(1).setMinWidth(80);
        this.table.getColumnModel().getColumn(1).setMaxWidth(80);
        this.table.getColumnModel().getColumn(1).setResizable(false);
    }

    public int showDialog() {
        DiscreteColourDecorator discreteColourDecorator = this.getDecorator();
        OptionsPanel optionsPanel = new OptionsPanel(6, 6);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setMinimumSize(new Dimension(120, 120));
        optionsPanel.addSpanningComponent(jScrollPane);
        optionsPanel.addComponentWithLabel("Scheme: ", this.colourSchemeCombo);
        this.colourSchemePanel.setBorder(BorderFactory.createBevelBorder(1));
        optionsPanel.addSpanningComponent(this.colourSchemePanel);
        JOptionPane jOptionPane = new JOptionPane(optionsPanel, 3, 2, null, null, null);
        jOptionPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialog = jOptionPane.createDialog(this.frame, "Setup colour range: " + discreteColourDecorator.getAttributeName());
        this.colourSchemeCombo.setSelectedItem(this.colourSchemeClassNameMap.get(discreteColourDecorator.getClass()));
        this.dialog.pack();
        this.dialog.setResizable(true);
        this.dialog.setVisible(true);
        int n = 2;
        Integer n2 = (Integer)jOptionPane.getValue();
        if (n2 != null && n2 != -1) {
            n = n2;
        }
        return n;
    }

    public void setDecorator(DiscreteColourDecorator discreteColourDecorator) {
        this.discreteValues = new ArrayList<Object>(discreteColourDecorator.getValues());
        for (String string : this.colourSchemeNamePanelMap.keySet()) {
            this.colourSchemeNamePanelMap.get(string).setDecorator(discreteColourDecorator);
        }
    }

    public DiscreteColourDecorator getDecorator() {
        String string = this.colourSchemeCombo.getSelectedItem().toString();
        DiscreteColourDecorator discreteColourDecorator = this.colourSchemeNamePanelMap.get(string).getDecorator();
        discreteColourDecorator.setValuesOrder(this.discreteValues);
        return discreteColourDecorator;
    }

    private class FixedColourSchemePanel
    implements ColourSchemePanel {
        private FixedDiscreteColourDecorator fixedDecorator = null;
        private JPanel panel = null;

        @Override
        public void setDecorator(DiscreteColourDecorator discreteColourDecorator) {
            if (discreteColourDecorator instanceof FixedDiscreteColourDecorator) {
                this.fixedDecorator = (FixedDiscreteColourDecorator)discreteColourDecorator;
            } else if (this.fixedDecorator == null) {
                this.fixedDecorator = new FixedDiscreteColourDecorator(discreteColourDecorator.getAttributeName());
            }
            this.fixedDecorator.setValues(DiscreteColourScaleDialog.this.discreteValues);
        }

        @Override
        public DiscreteColourDecorator getDecorator() {
            return this.fixedDecorator;
        }

        @Override
        public JPanel getPanel() {
            if (this.panel == null) {
                OptionsPanel optionsPanel = new OptionsPanel(6, 6);
                this.panel = optionsPanel;
            }
            return this.panel;
        }

        @Override
        public String getName() {
            return DiscreteColourScaleDialog.FIXED_COLOURS;
        }
    }

    private class HSBColourSchemePanel
    implements ColourSchemePanel {
        private boolean settingValues = false;
        private JComboBox primaryAxisCombo = new JComboBox<HSBDiscreteColourDecorator.Axis>(HSBDiscreteColourDecorator.Axis.values());
        private SpinnerNumberModel secondaryCountSpinnerModel = new SpinnerNumberModel(2, 1, 100, 1);
        private JSpinner secondaryCountSpinner = new JSpinner(this.secondaryCountSpinnerModel);
        private RangeSlider hueSlider = new RangeSlider(0, 1000);
        private RangeSlider saturationSlider = new RangeSlider(0, 1000);
        private RangeSlider brightnessSlider = new RangeSlider(0, 1000);
        private HSBDiscreteColourDecorator hsbDecorator = null;
        private JPanel panel = null;

        @Override
        public void setDecorator(DiscreteColourDecorator discreteColourDecorator) {
            if (discreteColourDecorator instanceof HSBDiscreteColourDecorator) {
                this.hsbDecorator = (HSBDiscreteColourDecorator)discreteColourDecorator;
            } else if (this.hsbDecorator == null) {
                this.hsbDecorator = new HSBDiscreteColourDecorator(discreteColourDecorator.getAttributeName());
            }
            this.settingValues = true;
            this.secondaryCountSpinnerModel.setValue(this.hsbDecorator.getSecondaryCount());
            this.hueSlider.setValue((int)(this.hsbDecorator.getHueLower() * 1000.0f));
            this.hueSlider.setUpperValue((int)(this.hsbDecorator.getHueUpper() * 1000.0f));
            this.saturationSlider.setValue((int)(this.hsbDecorator.getSaturationLower() * 1000.0f));
            this.saturationSlider.setUpperValue((int)(this.hsbDecorator.getSaturationUpper() * 1000.0f));
            this.brightnessSlider.setValue((int)(this.hsbDecorator.getBrightnessLower() * 1000.0f));
            this.brightnessSlider.setUpperValue((int)(this.hsbDecorator.getBrightnessUpper() * 1000.0f));
            this.settingValues = false;
            this.getDecorator();
            DiscreteColourScaleDialog.this.tableModel.fireTableDataChanged();
        }

        @Override
        public DiscreteColourDecorator getDecorator() {
            this.hsbDecorator.setSecondaryCount(this.secondaryCountSpinnerModel.getNumber().intValue());
            this.hsbDecorator.setHueLower((float)this.hueSlider.getValue() / 1000.0f);
            this.hsbDecorator.setHueUpper((float)this.hueSlider.getUpperValue() / 1000.0f);
            this.hsbDecorator.setSaturationLower((float)this.saturationSlider.getValue() / 1000.0f);
            this.hsbDecorator.setSaturationUpper((float)this.saturationSlider.getUpperValue() / 1000.0f);
            this.hsbDecorator.setBrightnessLower((float)this.brightnessSlider.getValue() / 1000.0f);
            this.hsbDecorator.setBrightnessUpper((float)this.brightnessSlider.getUpperValue() / 1000.0f);
            return this.hsbDecorator;
        }

        @Override
        public JPanel getPanel() {
            if (this.panel == null) {
                OptionsPanel optionsPanel = new OptionsPanel(6, 6);
                optionsPanel.addComponentWithLabel("Primary: ", this.primaryAxisCombo);
                optionsPanel.addComponentWithLabel("Secondary count: ", this.secondaryCountSpinner);
                optionsPanel.addComponentWithLabel("Hue: ", this.hueSlider);
                optionsPanel.addComponentWithLabel("Saturation: ", this.saturationSlider);
                optionsPanel.addComponentWithLabel("Brightness: ", this.brightnessSlider);
                this.primaryAxisCombo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        HSBColourSchemePanel.this.getDecorator();
                        DiscreteColourScaleDialog.this.tableModel.fireTableDataChanged();
                    }
                });
                ChangeListener changeListener = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        if (!HSBColourSchemePanel.this.settingValues) {
                            HSBColourSchemePanel.this.getDecorator();
                            DiscreteColourScaleDialog.this.tableModel.fireTableDataChanged();
                        }
                    }
                };
                this.secondaryCountSpinner.addChangeListener(changeListener);
                this.hueSlider.addChangeListener(changeListener);
                this.saturationSlider.addChangeListener(changeListener);
                this.brightnessSlider.addChangeListener(changeListener);
                this.panel = optionsPanel;
            }
            return this.panel;
        }

        @Override
        public String getName() {
            return DiscreteColourScaleDialog.HSB_SPECTRUM;
        }
    }

    private static interface ColourSchemePanel {
        public void setDecorator(DiscreteColourDecorator var1);

        public DiscreteColourDecorator getDecorator();

        public JPanel getPanel();

        public String getName();
    }

    public class TableRowTransferHandler
    extends TransferHandler {
        private final DataFlavor localObjectFlavor = new DataFlavor(ArrayList.class, "Integer Row Index");
        private JTable table = null;

        public TableRowTransferHandler(JTable jTable) {
            this.table = jTable;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            assert (jComponent == this.table);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int n : this.table.getSelectedRows()) {
                arrayList.add(n);
            }
            return new DataHandler(arrayList, this.localObjectFlavor.getMimeType());
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            boolean bl = transferSupport.getComponent() == this.table && transferSupport.isDrop() && transferSupport.isDataFlavorSupported(this.localObjectFlavor);
            this.table.setCursor(bl ? DragSource.DefaultMoveDrop : DragSource.DefaultMoveNoDrop);
            return bl;
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 2;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            JTable jTable = (JTable)transferSupport.getComponent();
            JTable.DropLocation dropLocation = (JTable.DropLocation)transferSupport.getDropLocation();
            int n = dropLocation.getRow();
            int n2 = this.table.getModel().getRowCount();
            if (n < 0 || n > n2) {
                n = n2;
            }
            jTable.setCursor(Cursor.getPredefinedCursor(0));
            try {
                List list = (List)transferSupport.getTransferable().getTransferData(this.localObjectFlavor);
                if (list != null && list.size() > 0) {
                    ((Reorderable)((Object)this.table.getModel())).reorder(list, n);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        int n3 = (Integer)iterator.next();
                        if (n <= n3) continue;
                        --n;
                    }
                    jTable.getSelectionModel().addSelectionInterval(n, n + list.size() - 1);
                    return true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return false;
        }

        @Override
        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            if (n == 2) {
                this.table.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;

        public ColorRenderer(boolean bl) {
            this.isBordered = bl;
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Color color = (Color)object;
            this.setBackground(color);
            if (this.isBordered) {
                if (bl) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getSelectionBackground());
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            this.setToolTipText("RGB value: " + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue());
            return this;
        }
    }

    class ColourTableModel
    extends DefaultTableModel
    implements Reorderable {
        private final String[] COLUMN_NAMES = new String[]{"Value", "Colour"};

        ColourTableModel() {
        }

        @Override
        public int getRowCount() {
            if (DiscreteColourScaleDialog.this.discreteValues == null) {
                return 0;
            }
            return DiscreteColourScaleDialog.this.discreteValues.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return DiscreteColourScaleDialog.this.discreteValues.get(n);
                }
                case 1: {
                    DiscreteColourDecorator discreteColourDecorator = DiscreteColourScaleDialog.this.getDecorator();
                    return discreteColourDecorator.getColor(discreteColourDecorator.getValues().get(n));
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 1) {
                return Color.class;
            }
            return String.class;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }

        @Override
        public void reorder(List<Integer> list, int n) {
            ArrayList arrayList = new ArrayList();
            for (int n2 : list) {
                arrayList.add(DiscreteColourScaleDialog.this.discreteValues.get(n2));
            }
            for (int i = list.size() - 1; i >= 0; --i) {
                int n2;
                n2 = list.get(i);
                DiscreteColourScaleDialog.this.discreteValues.remove(n2);
                if (n <= n2) continue;
                --n;
            }
            DiscreteColourScaleDialog.this.discreteValues.addAll(n, arrayList);
            this.fireTableDataChanged();
        }
    }

    static interface Reorderable {
        public void reorder(List<Integer> var1, int var2);
    }
}

