/*
 * Decompiled with CFR 0.152.
 */
package figtree.panel;

import figtree.treeviewer.TreeViewer;
import figtree.treeviewer.TreeViewerListener;
import figtree.treeviewer.decorators.AttributableDecorator;
import figtree.treeviewer.decorators.ContinuousScale;
import figtree.treeviewer.decorators.DiscreteColourDecorator;
import figtree.treeviewer.decorators.HSBDiscreteColourDecorator;
import figtree.treeviewer.decorators.InterpolatingColourDecorator;
import jam.controlpalettes.AbstractController;
import jam.panels.OptionsPanel;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import jebl.evolution.graphs.Node;
import jebl.evolution.trees.Tree;
import jebl.util.Attributable;

public class TreeColouringController
extends AbstractController {
    private static final String CONTROLLER_KEY = "appearance";
    private static final String BRANCH_COLOR_ATTRIBUTE_KEY = "branchColorAttribute";
    private final OptionsPanel optionsPanel;
    private final JComboBox branchColourAttributeCombo;

    public TreeColouringController(TreeViewer treeViewer) {
        this(treeViewer, "Colour by:");
    }

    public TreeColouringController(final TreeViewer treeViewer, String string) {
        AttributableDecorator attributableDecorator = new AttributableDecorator();
        attributableDecorator.setPaintAttributeName("!color");
        attributableDecorator.setStrokeAttributeName("!stroke");
        treeViewer.setBranchDecorator(attributableDecorator, false);
        this.optionsPanel = new OptionsPanel();
        this.branchColourAttributeCombo = new JComboBox<String>(new String[]{"No attributes"});
        this.setupAttributes(treeViewer.getTrees());
        this.branchColourAttributeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                HashSet<Node> hashSet = new HashSet<Node>();
                for (Tree object : treeViewer.getTrees()) {
                    for (Node node : object.getNodes()) {
                        hashSet.add(node);
                    }
                }
                String string = (String)TreeColouringController.this.branchColourAttributeCombo.getSelectedItem();
                if (string != null && string.length() > 0) {
                    if (string.endsWith("*")) {
                        DiscreteColourDecorator discreteColourDecorator = new DiscreteColourDecorator();
                        treeViewer.setBranchColouringDecorator(string.substring(0, string.length() - 2), discreteColourDecorator);
                        treeViewer.setBranchDecorator(null, false);
                    } else if (DiscreteColourDecorator.isDiscrete(string, hashSet)) {
                        HSBDiscreteColourDecorator hSBDiscreteColourDecorator = new HSBDiscreteColourDecorator(string, hashSet);
                        treeViewer.setBranchColouringDecorator(null, null);
                        treeViewer.setBranchDecorator(hSBDiscreteColourDecorator, false);
                    } else {
                        InterpolatingColourDecorator interpolatingColourDecorator = new InterpolatingColourDecorator(new ContinuousScale(string, hashSet), new Color(192, 16, 0), new Color(0, 16, 192));
                        treeViewer.setBranchColouringDecorator(null, null);
                        treeViewer.setBranchDecorator(interpolatingColourDecorator, false);
                    }
                }
            }
        });
        this.optionsPanel.addComponentWithLabel(string, this.branchColourAttributeCombo);
        treeViewer.addTreeViewerListener(new TreeViewerListener(){

            @Override
            public void treeChanged() {
                TreeColouringController.this.setupAttributes(treeViewer.getTrees());
                TreeColouringController.this.optionsPanel.repaint();
            }

            @Override
            public void treeSettingsChanged() {
            }
        });
    }

    private void setupAttributes(Collection<? extends Tree> collection) {
        Object object = this.branchColourAttributeCombo.getSelectedItem();
        this.branchColourAttributeCombo.removeAllItems();
        if (collection == null) {
            return;
        }
        for (Tree tree : collection) {
            for (String string : this.getAttributeNames(tree.getNodes())) {
                this.branchColourAttributeCombo.addItem(string);
            }
        }
        this.branchColourAttributeCombo.setSelectedItem(object);
    }

    private String[] getAttributeNames(Collection<? extends Attributable> collection) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Attributable attributable : collection) {
            for (String string : attributable.getAttributeNames()) {
                if (string.startsWith("!")) continue;
                Object object = attributable.getAttribute(string);
                if (!(object instanceof Object[])) {
                    treeSet.add(string);
                    continue;
                }
                boolean bl = true;
                Object[] objectArray = (Object[])object;
                boolean bl2 = true;
                for (Object object2 : objectArray) {
                    if (bl2 && !(object2 instanceof Integer) || !bl2 && !(object2 instanceof Double)) {
                        bl = false;
                        break;
                    }
                    bl2 = !bl2;
                }
                if (bl2) {
                    bl = false;
                }
                if (!bl) continue;
                treeSet.add(string + " *");
            }
        }
        String[] stringArray = new String[treeSet.size()];
        treeSet.toArray(stringArray);
        return stringArray;
    }

    @Override
    public JComponent getTitleComponent() {
        return null;
    }

    @Override
    public JPanel getPanel() {
        return this.optionsPanel;
    }

    @Override
    public boolean isInitiallyVisible() {
        return false;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void setSettings(Map<String, Object> map) {
        this.branchColourAttributeCombo.setSelectedItem(map.get("appearance.branchColorAttribute"));
    }

    @Override
    public void getSettings(Map<String, Object> map) {
        if (this.branchColourAttributeCombo.getSelectedItem() != null) {
            map.put("appearance.branchColorAttribute", this.branchColourAttributeCombo.getSelectedItem().toString());
        } else {
            map.put("appearance.branchColorAttribute", "none");
        }
    }
}

