/*
 * Decompiled with CFR 0.152.
 */
package figtree.panel;

import figtree.treeviewer.TreeViewer;
import figtree.treeviewer.painters.AttributeComboHelper;
import figtree.treeviewer.painters.LabelPainter;
import jam.controlpalettes.AbstractController;
import jam.panels.OptionsPanel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class LabelPainterController
extends AbstractController {
    private static final String DISPLAY_ATTRIBUTE_KEY = "displayAttribute";
    private final OptionsPanel optionsPanel;
    private final JComboBox tipComboBox;
    private final JComboBox nodeComboBox;
    private final JComboBox branchComboBox;
    private final String tipKey;
    private final String nodeKey;
    private final String branchKey;

    public LabelPainterController(String string, LabelPainter labelPainter, String string2, LabelPainter labelPainter2, String string3, LabelPainter labelPainter3, TreeViewer treeViewer) {
        this.tipKey = string;
        this.nodeKey = string2;
        this.branchKey = string3;
        this.optionsPanel = new OptionsPanel();
        this.tipComboBox = this.setupComboBox("Tips: ", labelPainter, treeViewer);
        this.tipComboBox.setSelectedIndex(1);
        this.nodeComboBox = this.setupComboBox("Nodes: ", labelPainter2, treeViewer);
        this.branchComboBox = this.setupComboBox("Branches: ", labelPainter3, treeViewer);
    }

    private JComboBox setupComboBox(String string, final LabelPainter labelPainter, TreeViewer treeViewer) {
        final JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("None");
        new AttributeComboHelper(jComboBox, treeViewer, "None");
        this.optionsPanel.addComponentWithLabel(string, jComboBox);
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                String string = (String)jComboBox.getSelectedItem();
                if (string.equals("none")) {
                    labelPainter.setVisible(false);
                } else {
                    labelPainter.setDisplayAttribute(string);
                    labelPainter.setVisible(true);
                }
            }
        });
        return jComboBox;
    }

    @Override
    public JComponent getTitleComponent() {
        return null;
    }

    @Override
    public JPanel getPanel() {
        return this.optionsPanel;
    }

    @Override
    public boolean isInitiallyVisible() {
        return false;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void setSettings(Map<String, Object> map) {
        this.tipComboBox.setSelectedItem(map.get(this.tipKey + "." + DISPLAY_ATTRIBUTE_KEY));
        this.nodeComboBox.setSelectedItem(map.get(this.nodeKey + "." + DISPLAY_ATTRIBUTE_KEY));
        this.branchComboBox.setSelectedItem(map.get(this.branchKey + "." + DISPLAY_ATTRIBUTE_KEY));
    }

    @Override
    public void getSettings(Map<String, Object> map) {
        map.put(this.tipKey + "." + DISPLAY_ATTRIBUTE_KEY, this.tipComboBox.getSelectedItem().toString());
        map.put(this.nodeKey + "." + DISPLAY_ATTRIBUTE_KEY, this.nodeComboBox.getSelectedItem().toString());
        map.put(this.branchKey + "." + DISPLAY_ATTRIBUTE_KEY, this.branchComboBox.getSelectedItem().toString());
    }

    public String getTitle() {
        return "";
    }
}

