/*
 * Decompiled with CFR 0.152.
 */
package figtree.panel;

import figtree.panel.LabelPainterController;
import figtree.panel.SimpleControlPalette;
import figtree.panel.SimpleLabelPainter;
import figtree.panel.SimpleTreeViewer;
import figtree.panel.TreeAppearanceController;
import figtree.panel.TreeColouringController;
import figtree.panel.TreeViewerController;
import figtree.panel.TreesController;
import figtree.treeviewer.TreeViewer;
import figtree.treeviewer.decorators.AttributableDecorator;
import figtree.treeviewer.decorators.ContinuousScale;
import figtree.treeviewer.decorators.Decorator;
import figtree.treeviewer.decorators.DiscreteColourDecorator;
import figtree.treeviewer.decorators.HSBDiscreteColourDecorator;
import figtree.treeviewer.decorators.InterpolatingColourDecorator;
import figtree.treeviewer.painters.LabelPainter;
import figtree.treeviewer.painters.ScaleBarPainter;
import jam.controlpalettes.ControlPalette;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import jebl.evolution.graphs.Node;
import jebl.evolution.trees.Tree;

public class FigTreePanel
extends JPanel {
    private final TreeViewer treeViewer;

    public FigTreePanel(Style style) {
        this(new SimpleTreeViewer(), new SimpleControlPalette(), null, style);
    }

    public FigTreePanel(TreeViewer treeViewer, ControlPalette controlPalette, ControlPalette controlPalette2, Style style) {
        this.treeViewer = treeViewer;
        if (controlPalette != null) {
            controlPalette.getPanel().setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY));
            controlPalette.getPanel().setBackground(new Color(231, 237, 246));
            controlPalette.getPanel().setOpaque(true);
        }
        if (controlPalette2 != null) {
            controlPalette2.getPanel().setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
            controlPalette2.getPanel().setBackground(new Color(231, 237, 246));
            controlPalette2.getPanel().setOpaque(true);
        }
        SimpleLabelPainter simpleLabelPainter = new SimpleLabelPainter(LabelPainter.PainterIntent.TIP);
        SimpleLabelPainter simpleLabelPainter2 = new SimpleLabelPainter(LabelPainter.PainterIntent.NODE);
        simpleLabelPainter2.setVisible(false);
        SimpleLabelPainter simpleLabelPainter3 = new SimpleLabelPainter(LabelPainter.PainterIntent.BRANCH);
        simpleLabelPainter3.setVisible(false);
        this.setLayout(new BorderLayout());
        switch (style) {
            case DEFAULT: {
                if (controlPalette == null) {
                    throw new IllegalArgumentException("DEFAULT style requires a controlPalette");
                }
                controlPalette.addController(new TreeViewerController(treeViewer));
                controlPalette.addController(new TreeAppearanceController(treeViewer, "tipLabels", simpleLabelPainter, "nodeLabels", simpleLabelPainter2, "branchLabels", simpleLabelPainter3));
                controlPalette.addController(new TreesController(treeViewer));
                controlPalette.addController(new LabelPainterController("tipLabels", simpleLabelPainter, "nodeLabels", simpleLabelPainter2, "branchLabels", simpleLabelPainter3, treeViewer));
                break;
            }
            case SIMPLE: {
                if (controlPalette == null) {
                    throw new IllegalArgumentException("SIMPLE style requires a controlPalette");
                }
                controlPalette.addController(new TreeViewerController(treeViewer));
                controlPalette.addController(new TreeAppearanceController(treeViewer, "tipLabels", simpleLabelPainter, "nodeLabels", simpleLabelPainter2, "branchLabels", simpleLabelPainter3));
                controlPalette.addController(new LabelPainterController("tipLabels", simpleLabelPainter, "nodeLabels", simpleLabelPainter2, "branchLabels", simpleLabelPainter3, treeViewer));
                break;
            }
            case MINIMAL: {
                break;
            }
            case ICARUS: {
                controlPalette.addController(new TreeViewerController(treeViewer, true));
                controlPalette.addController(new TreeAppearanceController(treeViewer, "tipLabels", simpleLabelPainter, "nodeLabels", simpleLabelPainter2, "branchLabels", simpleLabelPainter3, true));
                controlPalette.addController(new LabelPainterController("tipLabels", simpleLabelPainter, "nodeLabels", simpleLabelPainter2, "branchLabels", simpleLabelPainter3, treeViewer));
                controlPalette.addController(new TreesController(treeViewer));
                controlPalette2.addController(new TreeColouringController(treeViewer, "Clustering:"));
                this.add((Component)controlPalette2.getPanel(), "North");
                break;
            }
            case ICARUS_SMALL: {
                controlPalette.addController(new TreeViewerController(treeViewer, true));
                controlPalette.addController(new TreeAppearanceController(treeViewer, "tipLabels", simpleLabelPainter, "nodeLabels", simpleLabelPainter2, "branchLabels", simpleLabelPainter3, true));
                controlPalette2.addController(new TreeColouringController(treeViewer, "Clustering:"));
                this.add((Component)controlPalette2.getPanel(), "North");
            }
        }
        treeViewer.setTipLabelPainter(simpleLabelPainter);
        treeViewer.setNodeLabelPainter(simpleLabelPainter2);
        treeViewer.setBranchLabelPainter(simpleLabelPainter3);
        AttributableDecorator attributableDecorator = new AttributableDecorator();
        attributableDecorator.setPaintAttributeName("!color");
        attributableDecorator.setFontAttributeName("!font");
        simpleLabelPainter.setTextDecorator(attributableDecorator);
        ScaleBarPainter scaleBarPainter = new ScaleBarPainter();
        treeViewer.addScalePainter(scaleBarPainter);
        this.add((Component)treeViewer, "Center");
        if (controlPalette != null) {
            this.add((Component)controlPalette.getPanel(), "South");
        }
    }

    public void setColourBy(String string) {
        if (string == null) {
            this.treeViewer.setBranchColouringDecorator(null, null);
            this.treeViewer.setBranchDecorator(null, false);
        } else {
            HashSet<Node> hashSet = new HashSet<Node>();
            for (Tree tree : this.treeViewer.getTrees()) {
                for (Node node : tree.getNodes()) {
                    hashSet.add(node);
                }
            }
            if (string != null && string.length() > 0) {
                Object object;
                if (string.endsWith("*")) {
                    object = new DiscreteColourDecorator();
                    this.treeViewer.setBranchColouringDecorator(string.substring(0, string.length() - 2), (Decorator)object);
                    this.treeViewer.setBranchDecorator(null, false);
                } else if (DiscreteColourDecorator.isDiscrete(string, hashSet)) {
                    object = new HSBDiscreteColourDecorator(string, hashSet);
                    this.treeViewer.setBranchColouringDecorator(null, null);
                    this.treeViewer.setBranchDecorator((Decorator)object, false);
                } else {
                    object = new InterpolatingColourDecorator(new ContinuousScale(string, hashSet), new Color(192, 16, 0), new Color(0, 0, 0), new Color(0, 16, 192));
                    this.treeViewer.setBranchColouringDecorator(null, null);
                    this.treeViewer.setBranchDecorator((Decorator)object, false);
                }
            }
        }
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void setTree(Tree tree) {
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        if (tree != null) {
            arrayList.add(tree);
        }
        this.treeViewer.setTrees(arrayList);
    }

    public static enum Style {
        DEFAULT,
        SIMPLE,
        MINIMAL,
        ICARUS,
        ICARUS_SMALL;

    }
}

