/*
 * Decompiled with CFR 0.152.
 */
package figtree.application.preferences;

import figtree.application.FigTreeApplication;
import figtree.treeviewer.TreeAppearanceController;
import figtree.ui.components.ColorWellButton;
import jam.panels.OptionsPanel;
import jam.preferences.PreferencesSection;
import jam.util.IconUtils;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class AppearancePreferencesSection
implements PreferencesSection {
    Icon coloursToolIcon = IconUtils.getIcon(FigTreeApplication.class, "images/coloursTool.png");
    ColorWellButton selectionButton;
    JSpinner branchLineWidthSpinner;

    @Override
    public String getTitle() {
        return "Appearance";
    }

    @Override
    public Icon getIcon() {
        return this.coloursToolIcon;
    }

    @Override
    public JPanel getPanel() {
        OptionsPanel optionsPanel = new OptionsPanel(12, 18);
        this.selectionButton = new ColorWellButton(Color.white, "Choose Selection Colour");
        optionsPanel.addComponentWithLabel("Selection Colour:", this.selectionButton);
        optionsPanel.addSeparator();
        this.branchLineWidthSpinner = new JSpinner(new SpinnerNumberModel(1.0, 0.01, 48.0, 1.0));
        optionsPanel.addComponentWithLabel("Line Weight:", this.branchLineWidthSpinner);
        optionsPanel.addFlexibleSpace();
        return optionsPanel;
    }

    @Override
    public void retrievePreferences() {
        int n = TreeAppearanceController.PREFS.getInt("appearance.selectionColour", TreeAppearanceController.DEFAULT_SELECTION_COLOUR.getRGB());
        double d = TreeAppearanceController.PREFS.getFloat("appearance.branchLineWidth", TreeAppearanceController.DEFAULT_BRANCH_LINE_WIDTH);
        this.selectionButton.setSelectedColor(new Color(n));
        this.branchLineWidthSpinner.setValue(d);
    }

    @Override
    public void storePreferences() {
        int n = this.selectionButton.getSelectedColor().getRGB();
        float f = ((Number)this.branchLineWidthSpinner.getValue()).floatValue();
        TreeAppearanceController.PREFS.putInt("appearance.selectionColour", n);
        TreeAppearanceController.PREFS.putFloat("appearance.branchLineWidth", f);
    }
}

