/*
 * Decompiled with CFR 0.152.
 */
package figtree.application;

import figtree.treeviewer.AttributeColourController;
import figtree.treeviewer.ExtendedTreeViewer;
import figtree.treeviewer.MultipleTreesController;
import figtree.treeviewer.TimeScaleController;
import figtree.treeviewer.TreeAppearanceController;
import figtree.treeviewer.TreeViewer;
import figtree.treeviewer.TreeViewerController;
import figtree.treeviewer.TreesController;
import figtree.treeviewer.painters.BasicLabelPainter;
import figtree.treeviewer.painters.LabelPainter;
import figtree.treeviewer.painters.LabelPainterController;
import figtree.treeviewer.painters.LegendPainter;
import figtree.treeviewer.painters.LegendPainterController;
import figtree.treeviewer.painters.NodeBarController;
import figtree.treeviewer.painters.NodeBarPainter;
import figtree.treeviewer.painters.NodeShapeController;
import figtree.treeviewer.painters.NodeShapePainter;
import figtree.treeviewer.painters.ScaleAxisPainter;
import figtree.treeviewer.painters.ScaleAxisPainterController;
import figtree.treeviewer.painters.ScaleBarPainter;
import figtree.treeviewer.painters.ScaleBarPainterController;
import figtree.treeviewer.painters.ScaleGridPainter;
import jam.controlpalettes.ControlPalette;
import jam.disclosure.SlideOpenPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class FigTreePanel
extends JPanel {
    public static final int CONTROL_PALETTE_WIDTH = 200;
    private final TreeViewer treeViewer;
    private final TreeViewerController treeViewerController;
    private final TreesController treesController;
    private final ControlPalette controlPalette;
    private final SlideOpenPanel slideOpenPanel;

    public FigTreePanel(JFrame jFrame, ExtendedTreeViewer extendedTreeViewer, ControlPalette controlPalette) {
        this.treeViewer = extendedTreeViewer;
        this.controlPalette = controlPalette;
        controlPalette.getPanel().setBackground(new Color(231, 237, 246));
        controlPalette.getPanel().setOpaque(true);
        this.treeViewerController = new TreeViewerController(extendedTreeViewer);
        controlPalette.addController(this.treeViewerController);
        controlPalette.addController(new MultipleTreesController(extendedTreeViewer));
        AttributeColourController attributeColourController = new AttributeColourController(extendedTreeViewer, jFrame);
        controlPalette.addController(attributeColourController);
        controlPalette.addController(new TreeAppearanceController(extendedTreeViewer, jFrame, attributeColourController));
        this.treesController = new TreesController(extendedTreeViewer);
        controlPalette.addController(this.treesController);
        controlPalette.addController(new TimeScaleController(extendedTreeViewer));
        BasicLabelPainter basicLabelPainter = new BasicLabelPainter(LabelPainter.PainterIntent.TIP);
        controlPalette.addController(new LabelPainterController("Tip Labels", "tipLabels", basicLabelPainter, jFrame, attributeColourController, extendedTreeViewer));
        extendedTreeViewer.setTipLabelPainter(basicLabelPainter);
        BasicLabelPainter basicLabelPainter2 = new BasicLabelPainter(LabelPainter.PainterIntent.NODE);
        basicLabelPainter2.setVisible(false);
        controlPalette.addController(new LabelPainterController("Node Labels", "nodeLabels", basicLabelPainter2, jFrame, attributeColourController, extendedTreeViewer));
        extendedTreeViewer.setNodeLabelPainter(basicLabelPainter2);
        NodeBarPainter nodeBarPainter = new NodeBarPainter();
        nodeBarPainter.setForeground(new Color(24, 32, 228, 128));
        nodeBarPainter.setVisible(false);
        controlPalette.addController(new NodeBarController("Node Bars", nodeBarPainter, extendedTreeViewer));
        extendedTreeViewer.setNodeBarPainter(nodeBarPainter);
        NodeShapePainter nodeShapePainter = new NodeShapePainter();
        nodeShapePainter.setVisible(false);
        controlPalette.addController(new NodeShapeController("Node Shapes", nodeShapePainter, attributeColourController, extendedTreeViewer));
        extendedTreeViewer.setNodeShapePainter(nodeShapePainter);
        BasicLabelPainter basicLabelPainter3 = new BasicLabelPainter(LabelPainter.PainterIntent.BRANCH);
        basicLabelPainter3.setVisible(false);
        controlPalette.addController(new LabelPainterController("Branch Labels", "branchLabels", basicLabelPainter3, jFrame, attributeColourController, extendedTreeViewer));
        extendedTreeViewer.setBranchLabelPainter(basicLabelPainter3);
        ScaleBarPainter scaleBarPainter = new ScaleBarPainter();
        scaleBarPainter.setVisible(true);
        controlPalette.addController(new ScaleBarPainterController(scaleBarPainter, extendedTreeViewer));
        extendedTreeViewer.addScalePainter(scaleBarPainter);
        ScaleAxisPainter scaleAxisPainter = new ScaleAxisPainter();
        ScaleGridPainter scaleGridPainter = new ScaleGridPainter();
        scaleAxisPainter.setVisible(false);
        scaleGridPainter.setVisible(false);
        controlPalette.addController(new ScaleAxisPainterController(scaleAxisPainter, scaleGridPainter, extendedTreeViewer));
        extendedTreeViewer.addScalePainter(scaleAxisPainter);
        extendedTreeViewer.setScaleGridPainter(scaleGridPainter);
        LegendPainter legendPainter = new LegendPainter(attributeColourController);
        legendPainter.setVisible(false);
        controlPalette.addController(new LegendPainterController(legendPainter, attributeColourController, extendedTreeViewer));
        extendedTreeViewer.setLegendPainter(legendPainter);
        this.slideOpenPanel = new SlideOpenPanel(extendedTreeViewer);
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.GRAY));
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(22);
        int n = jScrollPane.getVerticalScrollBar().getWidth();
        int n2 = 200 + n;
        controlPalette.setPreferredWidth(n2);
        jScrollPane.setViewportView(controlPalette.getPanel());
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, this.slideOpenPanel);
        jSplitPane.putClientProperty("Quaqua.SplitPane.style", "bar");
        jSplitPane.setOneTouchExpandable(true);
        this.add((Component)jSplitPane, "Center");
        int n3 = jSplitPane.getLeftComponent().getPreferredSize().width;
        jSplitPane.getLeftComponent().setMinimumSize(new Dimension(n3, 0));
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public ControlPalette getControlPalette() {
        return this.controlPalette;
    }

    public void showUtilityPanel(JPanel jPanel) {
        if (jPanel == null) {
            return;
        }
        this.slideOpenPanel.showUtilityPanel(jPanel);
    }

    public void hideUtilityPanel() {
        this.slideOpenPanel.hideUtilityPanel();
    }

    public JPanel getUtilityPanel() {
        return this.slideOpenPanel.getUtilityPanel();
    }

    public void toggleMidpointRoot() {
        this.treesController.toggleMidpointRoot();
    }

    public void toggleIncreasingNodeOrder() {
        this.treesController.toggleIncreasingNodeOrder();
    }

    public void toggleDecreasingNodeOrder() {
        this.treesController.toggleDecreasingNodeOrder();
    }
}

