/*
 * Decompiled with CFR 0.152.
 */
package figtree.application;

import ch.randelshofer.quaqua.QuaquaManager;
import figtree.application.Arguments;
import figtree.application.FigTreeFrame;
import figtree.application.FigTreeMenuBarFactory;
import figtree.application.FigTreeNexusImporter;
import figtree.application.FigTreePanel;
import figtree.application.GraphicFormat;
import figtree.application.preferences.AppearancePreferencesSection;
import figtree.application.preferences.FontsPreferencesSection;
import figtree.treeviewer.ExtendedTreeViewer;
import jam.controlpalettes.BasicControlPalette;
import jam.framework.Application;
import jam.framework.DocumentFrame;
import jam.framework.DocumentFrameFactory;
import jam.framework.MenuBarFactory;
import jam.framework.MultiDocApplication;
import jam.mac.Utils;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jebl.evolution.io.ImportException;
import jebl.evolution.io.NewickImporter;
import jebl.evolution.io.NexusImporter;
import jebl.evolution.trees.Tree;

public class FigTreeApplication
extends MultiDocApplication {
    public static final String VERSION = "1.4.2";
    public static final String DATES = "2006-2014";
    public static FigTreeApplication application;
    private static boolean lafLoaded;

    public FigTreeApplication(MenuBarFactory menuBarFactory, String string, String string2, Icon icon, String string3, String string4) {
        super(menuBarFactory, string, string2, icon, string3, string4);
        this.addPreferencesSection(new AppearancePreferencesSection());
        this.addPreferencesSection(new FontsPreferencesSection());
    }

    @Override
    public DocumentFrame doOpenFile(File file) {
        DocumentFrame documentFrame = this.getUpperDocumentFrame();
        if (documentFrame != null && documentFrame.getFile() == null) {
            documentFrame.openFile(file);
            return documentFrame;
        }
        return super.doOpenFile(file);
    }

    public void doPaste() {
    }

    public static void createGraphic(String string, int n, int n2, String string2, String string3) {
        try {
            Object object;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
            String string4 = bufferedReader.readLine();
            while (string4 != null && string4.length() == 0) {
                string4 = bufferedReader.readLine();
            }
            bufferedReader.close();
            boolean bl = string4 != null && string4.toUpperCase().contains("#NEXUS");
            FileReader fileReader = new FileReader(string2);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            ExtendedTreeViewer extendedTreeViewer = new ExtendedTreeViewer();
            BasicControlPalette basicControlPalette = new BasicControlPalette(200, BasicControlPalette.DisplayMode.ONLY_ONE_OPEN);
            FigTreePanel figTreePanel = new FigTreePanel(null, extendedTreeViewer, basicControlPalette);
            basicControlPalette.getSettings(hashMap);
            ArrayList<Tree> arrayList = new ArrayList<Tree>();
            if (bl) {
                object = new FigTreeNexusImporter(fileReader);
                arrayList.add(((NexusImporter)object).importNextTree());
                try {
                    while (true) {
                        ((NexusImporter)object).findNextBlock();
                        if (!((NexusImporter)object).getNextBlockName().equalsIgnoreCase("FIGTREE")) continue;
                        ((FigTreeNexusImporter)object).parseFigTreeBlock(hashMap);
                    }
                }
                catch (EOFException eOFException) {}
            } else {
                object = new NewickImporter(fileReader, true);
                arrayList.add(((NewickImporter)object).importNextTree());
            }
            if (arrayList.size() == 0) {
                throw new ImportException("This file contained no trees.");
            }
            extendedTreeViewer.setTrees(arrayList);
            basicControlPalette.setSettings(hashMap);
            extendedTreeViewer.getContentPane().setSize(n, n2);
            object = string3 != null ? new FileOutputStream(string3) : System.out;
            GraphicFormat graphicFormat = null;
            if (string.equals("PDF")) {
                if (string3 != null) {
                    System.out.println("Creating PDF graphic: " + string3);
                }
                graphicFormat = GraphicFormat.PDF;
            } else if (string.equals("GIF")) {
                if (string3 != null) {
                    System.out.println("Creating GIF graphic: " + string3);
                }
                graphicFormat = GraphicFormat.GIF;
            } else if (string.equals("PNG")) {
                graphicFormat = GraphicFormat.PNG;
            } else if (string.equals("JPEG")) {
                graphicFormat = GraphicFormat.JPEG;
            } else {
                throw new RuntimeException("Unknown graphic format");
            }
            JComponent jComponent = extendedTreeViewer.getContentPane();
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            jComponent.paint(graphics2D);
            graphics2D.dispose();
            ImageIO.write((RenderedImage)bufferedImage, graphicFormat.getName(), (OutputStream)object);
        }
        catch (ImportException importException) {
            throw new RuntimeException("Error writing graphic file: " + importException);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error writing graphic file: " + iOException);
        }
    }

    public static void centreLine(String string, int n) {
        int n2 = n - string.length();
        int n3 = n2 / 2;
        for (int i = 0; i < n3; ++i) {
            System.out.print(" ");
        }
        System.out.println(string);
    }

    public static void printTitle() {
        System.out.println();
        FigTreeApplication.centreLine("FigTree v1.4.2, 2006-2014", 60);
        FigTreeApplication.centreLine("Tree Figure Drawing Tool", 60);
        FigTreeApplication.centreLine("Andrew Rambaut", 60);
        System.out.println();
        FigTreeApplication.centreLine("Institute of Evolutionary Biology", 60);
        FigTreeApplication.centreLine("University of Edinburgh", 60);
        FigTreeApplication.centreLine("a.rambaut@ed.ac.uk", 60);
        System.out.println();
        FigTreeApplication.centreLine("http://tree.bio.ed.ac.uk/", 60);
        FigTreeApplication.centreLine("Uses the Java Evolutionary Biology 2 Library (JEBL2)", 60);
        FigTreeApplication.centreLine("http://jebl2.googlecode.com/", 60);
        FigTreeApplication.centreLine("Thanks to Alexei Drummond, Joseph Heled, Philippe Lemey, ", 60);
        FigTreeApplication.centreLine("Tulio de Oliveira, Oliver Pybus, Beth Shapiro & Marc Suchard", 60);
        System.out.println();
    }

    public static void printUsage(Arguments arguments) {
        arguments.printUsage("figtree", "[<tree-file-name>] [<graphic-file-name>]");
        System.out.println();
        System.out.println("  Example: figtree test.tree");
        System.out.println("  Example: figtree -graphic PDF test.tree test.pdf");
        System.out.println("  Example: figtree -graphic GIF -width 320 -height 320 test.tree test.gif");
        System.out.println();
    }

    public static void main(String[] stringArray) {
        Object object2;
        String[] stringArray2;
        Arguments arguments = new Arguments(new Arguments.Option[]{new Arguments.StringOption("graphic", new String[]{"PDF", "SVG", "SWF", "PS", "EMF", "GIF"}, false, "produce a graphic with the given format"), new Arguments.IntegerOption("width", "the width of the graphic in pixels"), new Arguments.IntegerOption("height", "the height of the graphic in pixels"), new Arguments.Option("url", "the input file is a URL"), new Arguments.Option("help", "option to print this message")});
        try {
            arguments.parseArguments(stringArray);
        }
        catch (Arguments.ArgumentException argumentException) {
            System.out.println();
            System.out.println(argumentException.getMessage());
            System.out.println();
            FigTreeApplication.printTitle();
            FigTreeApplication.printUsage(arguments);
            System.exit(1);
        }
        if (arguments.hasOption("help")) {
            FigTreeApplication.printTitle();
            FigTreeApplication.printUsage(arguments);
            System.exit(0);
        }
        if (arguments.hasOption("graphic")) {
            int n = 800;
            int n2 = 600;
            if (arguments.hasOption("width")) {
                n = arguments.getIntegerOption("width");
            }
            if (arguments.hasOption("height")) {
                n2 = arguments.getIntegerOption("height");
            }
            String string = arguments.getStringOption("graphic");
            stringArray2 = arguments.getLeftoverArguments();
            if (stringArray2.length == 0) {
                FigTreeApplication.printTitle();
                FigTreeApplication.printUsage(arguments);
                System.exit(0);
            } else if (stringArray2.length == 1) {
                FigTreeApplication.createGraphic(string, n, n2, stringArray2[0], stringArray2.length > 1 ? stringArray2[1] : null);
                System.exit(0);
            } else {
                FigTreeApplication.printTitle();
                FigTreeApplication.createGraphic(string, n, n2, stringArray2[0], stringArray2.length > 1 ? stringArray2[1] : null);
                System.exit(0);
            }
        }
        if (Utils.isMacOSX()) {
            if (Utils.getMacOSXMajorVersionNumber() >= 5) {
                System.setProperty("apple.awt.brushMetalLook", "true");
            }
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("apple.awt.draggableWindowBackground", "true");
            System.setProperty("apple.awt.showGrowBox", "true");
            System.setProperty("apple.awt.graphics.UseQuartz", "true");
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            HashSet<String> hashSet = new HashSet<String>();
                            hashSet.add("ColorChooser");
                            hashSet.add("FileChooser");
                            hashSet.add("Component");
                            hashSet.add("Browser");
                            hashSet.add("Tree");
                            hashSet.add("SplitPane");
                            hashSet.add("TitledBorder");
                            try {
                                QuaquaManager.setIncludedUIs(hashSet);
                            }
                            catch (NoClassDefFoundError noClassDefFoundError) {
                                // empty catch block
                            }
                            UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
                            lafLoaded = true;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            UIManager.put("SystemFont", new Font("Lucida Grande", 0, 13));
            UIManager.put("SmallSystemFont", new Font("Lucida Grande", 0, 11));
        }
        if (!lafLoaded) {
            for (UIManager.LookAndFeelInfo object3 : object2 = UIManager.getInstalledLookAndFeels()) {
                System.out.println(object3);
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object2 = FigTreeApplication.class.getResource("images/figtreeLogo.png");
        ImageIcon imageIcon = null;
        if (object2 != null) {
            imageIcon = new ImageIcon((URL)object2);
        }
        stringArray2 = "<html><center>Tree Figure Drawing Tool<br>Version 1.4.2<br>2006-2014, Andrew Rambaut<br>Institute of Evolutionary Biology, University of Edinburgh.<br><a href=\"http://tree.bio.ed.ac.uk/\">http://tree.bio.ed.ac.uk/</a><br><br>Source code available from:<br><a href=\"https://figtree.googlecode.com/\">http://figtree.googlecode.com/</a><br><br>Uses the Java Evolutionary Biology 2 Library (JEBL2)<br><a href=\"https://jebl2.googlecode.com/\">http://jebl2.googlecode.com/</a><br><br>Thanks to Alexei Drummond, Joseph Heled, Philippe Lemey, <br>Tulio de Oliveira, Oliver Pybus, Beth Shapiro & Marc Suchard</center></html>";
        String string = "http://tree.bio.ed.ac.uk/software/figtree/";
        String string2 = "http://tree.bio.ed.ac.uk/software/figtree/";
        application = new FigTreeApplication(new FigTreeMenuBarFactory(), "FigTree", (String)stringArray2, imageIcon, string, string2);
        application.setDocumentFrameFactory(new DocumentFrameFactory(){

            @Override
            public DocumentFrame createDocumentFrame(Application application, MenuBarFactory menuBarFactory) {
                return new FigTreeFrame("FigTree v1.4.2");
            }
        });
        application.initialize();
        boolean bl = arguments.hasOption("url");
        String[] stringArray3 = arguments.getLeftoverArguments();
        if (stringArray3.length > 0) {
            for (String string3 : stringArray3) {
                if (bl) {
                    FigTreeFrame figTreeFrame = (FigTreeFrame)application.doNew();
                    try {
                        figTreeFrame.readFromURL(new URL(string3));
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                application.doOpen(string3);
            }
        }
        if (application.getUpperDocumentFrame() == null) {
            application.doNew();
        }
    }

    static {
        lafLoaded = false;
    }
}

