/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.codec;

import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Image;
import com.itextpdf.text.ImgJBIG2;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.itextpdf.text.pdf.codec.JBIG2SegmentReader;

public class JBIG2Image {
    public static byte[] getGlobalSegment(RandomAccessFileOrArray randomAccessFileOrArray) {
        try {
            JBIG2SegmentReader jBIG2SegmentReader = new JBIG2SegmentReader(randomAccessFileOrArray);
            jBIG2SegmentReader.read();
            return jBIG2SegmentReader.getGlobal(true);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Image getJbig2Image(RandomAccessFileOrArray randomAccessFileOrArray, int n) {
        if (n < 1) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.page.number.must.be.gt.eq.1"));
        }
        try {
            JBIG2SegmentReader jBIG2SegmentReader = new JBIG2SegmentReader(randomAccessFileOrArray);
            jBIG2SegmentReader.read();
            JBIG2SegmentReader.JBIG2Page jBIG2Page = jBIG2SegmentReader.getPage(n);
            ImgJBIG2 imgJBIG2 = new ImgJBIG2(jBIG2Page.pageBitmapWidth, jBIG2Page.pageBitmapHeight, jBIG2Page.getData(true), jBIG2SegmentReader.getGlobal(true));
            return imgJBIG2;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static int getNumberOfPages(RandomAccessFileOrArray randomAccessFileOrArray) {
        try {
            JBIG2SegmentReader jBIG2SegmentReader = new JBIG2SegmentReader(randomAccessFileOrArray);
            jBIG2SegmentReader.read();
            return jBIG2SegmentReader.numberOfPages();
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }
}

