/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.error_messages.MessageLocalization;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;

public class ICC_Profile {
    protected byte[] data;
    protected int numComponents;
    private static HashMap cstags = new HashMap();

    protected ICC_Profile() {
    }

    public static ICC_Profile getInstance(byte[] byArray) {
        try {
            if (byArray.length < 128 || byArray[36] != 97 || byArray[37] != 99 || byArray[38] != 115 || byArray[39] != 112) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("invalid.icc.profile"));
            }
            ICC_Profile iCC_Profile = new ICC_Profile();
            iCC_Profile.data = byArray;
            Object v = cstags.get(new String(byArray, 16, 4, "US-ASCII"));
            iCC_Profile.numComponents = v == null ? 0 : (Integer)v;
            return iCC_Profile;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static ICC_Profile getInstance(InputStream inputStream) {
        try {
            byte[] byArray = new byte[128];
            int n = byArray.length;
            int n2 = 0;
            while (n > 0) {
                int n3 = inputStream.read(byArray, n2, n);
                if (n3 < 0) {
                    throw new IllegalArgumentException(MessageLocalization.getComposedMessage("invalid.icc.profile"));
                }
                n -= n3;
                n2 += n3;
            }
            if (byArray[36] != 97 || byArray[37] != 99 || byArray[38] != 115 || byArray[39] != 112) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("invalid.icc.profile"));
            }
            n = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            n -= byArray.length;
            n2 = byArray.length;
            while (n > 0) {
                int n4 = inputStream.read(byArray2, n2, n);
                if (n4 < 0) {
                    throw new IllegalArgumentException(MessageLocalization.getComposedMessage("invalid.icc.profile"));
                }
                n -= n4;
                n2 += n4;
            }
            return ICC_Profile.getInstance(byArray2);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static ICC_Profile GetInstance(String string) {
        FileInputStream fileInputStream = null;
        try {
            ICC_Profile iCC_Profile;
            fileInputStream = new FileInputStream(string);
            ICC_Profile iCC_Profile2 = iCC_Profile = ICC_Profile.getInstance(fileInputStream);
            return iCC_Profile2;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    static {
        cstags.put("XYZ ", new Integer(3));
        cstags.put("Lab ", new Integer(3));
        cstags.put("Luv ", new Integer(3));
        cstags.put("YCbr", new Integer(3));
        cstags.put("Yxy ", new Integer(3));
        cstags.put("RGB ", new Integer(3));
        cstags.put("GRAY", new Integer(1));
        cstags.put("HSV ", new Integer(3));
        cstags.put("HLS ", new Integer(3));
        cstags.put("CMYK", new Integer(4));
        cstags.put("CMY ", new Integer(3));
        cstags.put("2CLR", new Integer(2));
        cstags.put("3CLR", new Integer(3));
        cstags.put("4CLR", new Integer(4));
        cstags.put("5CLR", new Integer(5));
        cstags.put("6CLR", new Integer(6));
        cstags.put("7CLR", new Integer(7));
        cstags.put("8CLR", new Integer(8));
        cstags.put("9CLR", new Integer(9));
        cstags.put("ACLR", new Integer(10));
        cstags.put("BCLR", new Integer(11));
        cstags.put("CCLR", new Integer(12));
        cstags.put("DCLR", new Integer(13));
        cstags.put("ECLR", new Integer(14));
        cstags.put("FCLR", new Integer(15));
    }
}

