/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.factories;

import com.itextpdf.text.Anchor;
import com.itextpdf.text.Annotation;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.ChapterAutoNumber;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.ElementTags;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Image;
import com.itextpdf.text.List;
import com.itextpdf.text.ListItem;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Section;
import com.itextpdf.text.Utilities;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.html.Markup;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Properties;

public class ElementFactory {
    public static Chunk getChunk(Properties properties) {
        Chunk chunk = new Chunk();
        chunk.setFont(FontFactory.getFont(properties));
        String string = properties.getProperty("itext");
        if (string != null) {
            chunk.append(string);
        }
        if ((string = properties.getProperty(ElementTags.LOCALGOTO)) != null) {
            chunk.setLocalGoto(string);
        }
        if ((string = properties.getProperty(ElementTags.REMOTEGOTO)) != null) {
            String string2 = properties.getProperty("page");
            if (string2 != null) {
                chunk.setRemoteGoto(string, Integer.parseInt(string2));
            } else {
                String string3 = properties.getProperty("destination");
                if (string3 != null) {
                    chunk.setRemoteGoto(string, string3);
                }
            }
        }
        if ((string = properties.getProperty(ElementTags.LOCALDESTINATION)) != null) {
            chunk.setLocalDestination(string);
        }
        if ((string = properties.getProperty(ElementTags.SUBSUPSCRIPT)) != null) {
            chunk.setTextRise(Float.parseFloat(string + "f"));
        }
        if ((string = properties.getProperty("vertical-align")) != null && string.endsWith("%")) {
            float f = Float.parseFloat(string.substring(0, string.length() - 1) + "f") / 100.0f;
            chunk.setTextRise(f * chunk.getFont().getSize());
        }
        if ((string = properties.getProperty(ElementTags.GENERICTAG)) != null) {
            chunk.setGenericTag(string);
        }
        if ((string = properties.getProperty("backgroundcolor")) != null) {
            chunk.setBackground(Markup.decodeColor(string));
        }
        return chunk;
    }

    public static Phrase getPhrase(Properties properties) {
        Phrase phrase = new Phrase();
        phrase.setFont(FontFactory.getFont(properties));
        String string = properties.getProperty("leading");
        if (string != null) {
            phrase.setLeading(Float.parseFloat(string + "f"));
        }
        if ((string = properties.getProperty("line-height")) != null) {
            phrase.setLeading(Markup.parseLength(string, 12.0f));
        }
        if ((string = properties.getProperty("itext")) != null) {
            Chunk chunk = new Chunk(string);
            string = properties.getProperty(ElementTags.GENERICTAG);
            if (string != null) {
                chunk.setGenericTag(string);
            }
            phrase.add(chunk);
        }
        return phrase;
    }

    public static Anchor getAnchor(Properties properties) {
        Anchor anchor = new Anchor(ElementFactory.getPhrase(properties));
        String string = properties.getProperty("name");
        if (string != null) {
            anchor.setName(string);
        }
        if ((string = (String)properties.remove("reference")) != null) {
            anchor.setReference(string);
        }
        return anchor;
    }

    public static Paragraph getParagraph(Properties properties) {
        Paragraph paragraph = new Paragraph(ElementFactory.getPhrase(properties));
        String string = properties.getProperty("align");
        if (string != null) {
            paragraph.setAlignment(string);
        }
        if ((string = properties.getProperty("indentationleft")) != null) {
            paragraph.setIndentationLeft(Float.parseFloat(string + "f"));
        }
        if ((string = properties.getProperty("indentationright")) != null) {
            paragraph.setIndentationRight(Float.parseFloat(string + "f"));
        }
        return paragraph;
    }

    public static ListItem getListItem(Properties properties) {
        ListItem listItem = new ListItem(ElementFactory.getParagraph(properties));
        return listItem;
    }

    public static List getList(Properties properties) {
        List list = new List();
        list.setNumbered(Utilities.checkTrueOrFalse(properties, "numbered"));
        list.setLettered(Utilities.checkTrueOrFalse(properties, "lettered"));
        list.setLowercase(Utilities.checkTrueOrFalse(properties, "lowercase"));
        list.setAutoindent(Utilities.checkTrueOrFalse(properties, "autoindent"));
        list.setAlignindent(Utilities.checkTrueOrFalse(properties, "alignindent"));
        String string = properties.getProperty("first");
        if (string != null) {
            char c = string.charAt(0);
            if (Character.isLetter(c)) {
                list.setFirst(c);
            } else {
                list.setFirst(Integer.parseInt(string));
            }
        }
        if ((string = properties.getProperty("listsymbol")) != null) {
            list.setListSymbol(new Chunk(string, FontFactory.getFont(properties)));
        }
        if ((string = properties.getProperty("indentationleft")) != null) {
            list.setIndentationLeft(Float.parseFloat(string + "f"));
        }
        if ((string = properties.getProperty("indentationright")) != null) {
            list.setIndentationRight(Float.parseFloat(string + "f"));
        }
        if ((string = properties.getProperty("symbolindent")) != null) {
            list.setSymbolIndent(Float.parseFloat(string));
        }
        return list;
    }

    public static ChapterAutoNumber getChapter(Properties properties) {
        ChapterAutoNumber chapterAutoNumber = new ChapterAutoNumber("");
        ElementFactory.setSectionParameters(chapterAutoNumber, properties);
        return chapterAutoNumber;
    }

    public static Section getSection(Section section, Properties properties) {
        Section section2 = section.addSection("");
        ElementFactory.setSectionParameters(section2, properties);
        return section2;
    }

    private static void setSectionParameters(Section section, Properties properties) {
        String string = properties.getProperty("numberdepth");
        if (string != null) {
            section.setNumberDepth(Integer.parseInt(string));
        }
        if ((string = properties.getProperty("indent")) != null) {
            section.setIndentation(Float.parseFloat(string + "f"));
        }
        if ((string = properties.getProperty("indentationleft")) != null) {
            section.setIndentationLeft(Float.parseFloat(string + "f"));
        }
        if ((string = properties.getProperty("indentationright")) != null) {
            section.setIndentationRight(Float.parseFloat(string + "f"));
        }
    }

    public static Image getImage(Properties properties) throws BadElementException, MalformedURLException, IOException {
        String string = properties.getProperty("url");
        if (string == null) {
            throw new MalformedURLException(MessageLocalization.getComposedMessage("the.url.of.the.image.is.missing"));
        }
        Image image = Image.getInstance(string);
        string = properties.getProperty("align");
        int n = 0;
        if (string != null) {
            if ("Left".equalsIgnoreCase(string)) {
                n |= 0;
            } else if ("Right".equalsIgnoreCase(string)) {
                n |= 2;
            } else if ("Middle".equalsIgnoreCase(string)) {
                n |= 1;
            }
        }
        if ("true".equalsIgnoreCase(properties.getProperty("underlying"))) {
            n |= 8;
        }
        if ("true".equalsIgnoreCase(properties.getProperty("textwrap"))) {
            n |= 4;
        }
        image.setAlignment(n);
        string = properties.getProperty("alt");
        if (string != null) {
            image.setAlt(string);
        }
        String string2 = properties.getProperty("absolutex");
        String string3 = properties.getProperty("absolutey");
        if (string2 != null && string3 != null) {
            image.setAbsolutePosition(Float.parseFloat(string2 + "f"), Float.parseFloat(string3 + "f"));
        }
        if ((string = properties.getProperty("plainwidth")) != null) {
            image.scaleAbsoluteWidth(Float.parseFloat(string + "f"));
        }
        if ((string = properties.getProperty("plainheight")) != null) {
            image.scaleAbsoluteHeight(Float.parseFloat(string + "f"));
        }
        if ((string = properties.getProperty("rotation")) != null) {
            image.setRotation(Float.parseFloat(string + "f"));
        }
        return image;
    }

    public static Annotation getAnnotation(Properties properties) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        String string = properties.getProperty("llx");
        if (string != null) {
            f = Float.parseFloat(string + "f");
        }
        if ((string = properties.getProperty("lly")) != null) {
            f2 = Float.parseFloat(string + "f");
        }
        if ((string = properties.getProperty("urx")) != null) {
            f3 = Float.parseFloat(string + "f");
        }
        if ((string = properties.getProperty("ury")) != null) {
            f4 = Float.parseFloat(string + "f");
        }
        String string2 = properties.getProperty("title");
        String string3 = properties.getProperty("content");
        if (string2 != null || string3 != null) {
            return new Annotation(string2, string3, f, f2, f3, f4);
        }
        string = properties.getProperty("url");
        if (string != null) {
            return new Annotation(f, f2, f3, f4, string);
        }
        string = properties.getProperty("named");
        if (string != null) {
            return new Annotation(f, f2, f3, f4, Integer.parseInt(string));
        }
        String string4 = properties.getProperty("file");
        String string5 = properties.getProperty("destination");
        String string6 = (String)properties.remove("page");
        if (string4 != null) {
            if (string5 != null) {
                return new Annotation(f, f2, f3, f4, string4, string5);
            }
            if (string6 != null) {
                return new Annotation(f, f2, f3, f4, string4, Integer.parseInt(string6));
            }
        }
        return new Annotation("", "", f, f2, f3, f4);
    }
}

