/*
 * Decompiled with CFR 0.152.
 */
package jam.panels;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class DragScrollHandler
extends MouseAdapter {
    private JComponent component;
    private Point pressed;
    private Point here;
    private Rectangle visiRect;

    public DragScrollHandler(JComponent jComponent) {
        this.component = jComponent;
        jComponent.addMouseListener(this);
        jComponent.addMouseMotionListener(this);
    }

    public static void createDragScrollHandlerFor(JComponent jComponent) {
        new DragScrollHandler(jComponent);
    }

    public void dispose() {
        this.component.removeMouseListener(this);
        this.component.removeMouseMotionListener(this);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.pressed = mouseEvent.getPoint();
        this.visiRect = this.component.getVisibleRect();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.here = mouseEvent.getPoint();
        this.visiRect.x += this.pressed.x - this.here.x;
        this.visiRect.y += this.pressed.y - this.here.y;
        this.component.scrollRectToVisible(this.visiRect);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Rectangle rectangle = DragScrollHandler.this.component.getVisibleRect();
                ((DragScrollHandler)DragScrollHandler.this).pressed.x += rectangle.x - ((DragScrollHandler)DragScrollHandler.this).visiRect.x;
                ((DragScrollHandler)DragScrollHandler.this).pressed.y += rectangle.y - ((DragScrollHandler)DragScrollHandler.this).visiRect.y;
                DragScrollHandler.this.visiRect = rectangle;
            }
        });
    }
}

