/*
 * Decompiled with CFR 0.152.
 */
package jam.framework;

import jam.framework.AbstractFrame;
import jam.framework.Application;
import jam.framework.DocumentFrame;
import jam.framework.DocumentFrameFactory;
import jam.framework.MenuBarFactory;
import jam.framework.MultiDocMenuBarFactory;
import jam.mac.Utils;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class MultiDocApplication
extends Application {
    private DocumentFrameFactory documentFrameFactory = null;
    private AbstractFrame invisibleFrame = null;
    private DocumentFrame upperDocumentFrame = null;
    private ArrayList<DocumentFrame> documents = new ArrayList();

    public MultiDocApplication(String string, String string2, Icon icon) {
        super(new MultiDocMenuBarFactory(), string, string2, icon);
    }

    public MultiDocApplication(String string, String string2, Icon icon, String string3, String string4) {
        super(new MultiDocMenuBarFactory(), string, string2, icon, string3, string4);
    }

    public MultiDocApplication(MenuBarFactory menuBarFactory, String string, String string2, Icon icon) {
        super(menuBarFactory, string, string2, icon);
    }

    public MultiDocApplication(MenuBarFactory menuBarFactory, String string, String string2, Icon icon, String string3, String string4) {
        super(menuBarFactory, string, string2, icon, string3, string4);
    }

    public final void initialize() {
        this.setupFramelessMenuBar();
        if (Utils.isMacOSX()) {
            Utils.macOSXRegistration(this);
        }
    }

    public void setDocumentFrameFactory(DocumentFrameFactory documentFrameFactory) {
        this.documentFrameFactory = documentFrameFactory;
    }

    protected JFrame getDefaultFrame() {
        DocumentFrame documentFrame = this.getUpperDocumentFrame();
        if (documentFrame == null) {
            return this.invisibleFrame;
        }
        return documentFrame;
    }

    protected DocumentFrame createDocumentFrame() {
        return this.documentFrameFactory.createDocumentFrame(this, MultiDocApplication.getMenuBarFactory());
    }

    public void destroyDocumentFrame(DocumentFrame documentFrame) {
        this.closeDocumentFrame(documentFrame);
    }

    public DocumentFrame doNew() {
        DocumentFrame documentFrame = this.createDocumentFrame();
        this.addDocumentFrame(documentFrame);
        return documentFrame;
    }

    public DocumentFrame doOpenFile(File file) {
        DocumentFrame documentFrame = this.getDocumentFrame(file);
        if (documentFrame == null && (documentFrame = this.createDocumentFrame()).openFile(file)) {
            this.addDocumentFrame(documentFrame);
        }
        documentFrame.toFront();
        return documentFrame;
    }

    public void doQuit() {
        boolean bl = true;
        while (this.documents.size() > 0) {
            DocumentFrame documentFrame = this.documents.get(0);
            if (!documentFrame.requestClose()) {
                return;
            }
            this.documents.remove(documentFrame);
            if (documentFrame.getWindowListeners().length > 0) {
                documentFrame.removeWindowListener(documentFrame.getWindowListeners()[0]);
            }
            documentFrame.setVisible(false);
            documentFrame.dispose();
        }
        if (bl) {
            System.exit(0);
        }
    }

    public DocumentFrame getUpperDocumentFrame() {
        return this.upperDocumentFrame;
    }

    public DocumentFrame getDocumentFrame(File file) {
        if (this.documents != null && this.documents.size() > 0) {
            for (DocumentFrame documentFrame : this.documents) {
                if (documentFrame == null || documentFrame.getFile() != file) continue;
                return documentFrame;
            }
        }
        return null;
    }

    private void documentFrameActivated(DocumentFrame documentFrame) {
        this.upperDocumentFrame = documentFrame;
    }

    private void documentFrameClosing(DocumentFrame documentFrame) {
        if (documentFrame.requestClose()) {
            this.closeDocumentFrame(documentFrame);
        }
    }

    private void closeDocumentFrame(DocumentFrame documentFrame) {
        this.documents.remove(documentFrame);
        if (documentFrame.getWindowListeners().length > 0) {
            documentFrame.removeWindowListener(documentFrame.getWindowListeners()[0]);
        }
        documentFrame.setVisible(false);
        documentFrame.dispose();
        if (this.documents.size() == 0) {
            this.doQuit();
        }
    }

    private void addDocumentFrame(DocumentFrame documentFrame) {
        documentFrame.initialize();
        documentFrame.setVisible(true);
        documentFrame.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                MultiDocApplication.this.documentFrameActivated((DocumentFrame)windowEvent.getWindow());
            }

            public void windowClosing(WindowEvent windowEvent) {
                MultiDocApplication.this.documentFrameClosing((DocumentFrame)windowEvent.getWindow());
            }
        });
        this.documents.add(documentFrame);
        this.upperDocumentFrame = documentFrame;
    }

    private void setupFramelessMenuBar() {
        if (Utils.isMacOSX() && System.getProperty("apple.laf.useScreenMenuBar") != null && System.getProperty("apple.laf.useScreenMenuBar").equalsIgnoreCase("true")) {
            if (this.invisibleFrame == null) {
                this.invisibleFrame = new AbstractFrame(){

                    protected void initializeComponents() {
                        this.getSaveAction().setEnabled(false);
                        this.getSaveAsAction().setEnabled(false);
                        if (this.getImportAction() != null) {
                            this.getImportAction().setEnabled(false);
                        }
                        if (this.getExportAction() != null) {
                            this.getExportAction().setEnabled(false);
                        }
                        this.getPrintAction().setEnabled(false);
                        this.getCutAction().setEnabled(false);
                        this.getCopyAction().setEnabled(false);
                        this.getPasteAction().setEnabled(false);
                        this.getDeleteAction().setEnabled(false);
                        this.getSelectAllAction().setEnabled(false);
                        this.getFindAction().setEnabled(false);
                        this.getZoomWindowAction().setEnabled(false);
                        this.getMinimizeWindowAction().setEnabled(false);
                        this.getCloseWindowAction().setEnabled(false);
                    }

                    public boolean requestClose() {
                        return false;
                    }

                    public JComponent getExportableComponent() {
                        return null;
                    }
                };
                this.invisibleFrame.setDefaultCloseOperation(0);
                try {
                    Method method = this.invisibleFrame.getClass().getMethod("setUndecorated", Boolean.TYPE);
                    method.invoke((Object)this.invisibleFrame, Boolean.TRUE);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.invisibleFrame.setSize(0, 0);
                this.invisibleFrame.pack();
            }
            this.invisibleFrame.initialize();
            if (!this.invisibleFrame.isVisible()) {
                this.invisibleFrame.setVisible(true);
            }
            this.invisibleFrame.pack();
        }
    }
}

