/*
 * Decompiled with CFR 0.152.
 */
package figtree.webui;

import eu.webtoolkit.jwt.AlignmentFlag;
import eu.webtoolkit.jwt.Signal;
import eu.webtoolkit.jwt.Signal1;
import eu.webtoolkit.jwt.WApplication;
import eu.webtoolkit.jwt.WBoxLayout;
import eu.webtoolkit.jwt.WCheckBox;
import eu.webtoolkit.jwt.WComboBox;
import eu.webtoolkit.jwt.WContainerWidget;
import eu.webtoolkit.jwt.WEnvironment;
import eu.webtoolkit.jwt.WFormWidget;
import eu.webtoolkit.jwt.WHBoxLayout;
import eu.webtoolkit.jwt.WIntValidator;
import eu.webtoolkit.jwt.WLabel;
import eu.webtoolkit.jwt.WLayout;
import eu.webtoolkit.jwt.WLength;
import eu.webtoolkit.jwt.WObject;
import eu.webtoolkit.jwt.WSpinBox;
import eu.webtoolkit.jwt.WVBoxLayout;
import eu.webtoolkit.jwt.WValidator;
import eu.webtoolkit.jwt.WWidget;
import figtree.application.FigTreeNexusImporter;
import figtree.panel.SimpleLabelPainter;
import figtree.treeviewer.TreePane;
import figtree.treeviewer.painters.LabelPainter;
import figtree.treeviewer.treelayouts.PolarTreeLayout;
import figtree.treeviewer.treelayouts.RadialTreeLayout;
import figtree.treeviewer.treelayouts.RectilinearTreeLayout;
import figtree.webui.FileUploadWidget;
import figtree.webui.TreeWidget;
import java.awt.BasicStroke;
import java.awt.Font;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import jebl.evolution.io.ImportException;
import jebl.evolution.io.NewickImporter;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.SortedRootedTree;
import jebl.evolution.trees.TransformedRootedTree;
import jebl.evolution.trees.Tree;

public class FigTreeWebApplication
extends WApplication {
    private TreeWidget treeWidget;
    private SimpleLabelPainter tipPainter;
    private SimpleLabelPainter nodePainter;
    private SimpleLabelPainter branchPainter;

    public FigTreeWebApplication(WEnvironment wEnvironment) {
        super(wEnvironment);
        this.setTitle("FigTree");
        this.useStyleSheet("figtree.css");
        WVBoxLayout wVBoxLayout = new WVBoxLayout((WWidget)this.getRoot());
        FileUploadWidget fileUploadWidget = new FileUploadWidget();
        fileUploadWidget.fileUploaded().addListener((WObject)this, (Signal1.Listener)new Signal1.Listener<String>(){

            public void trigger(String string) {
                FigTreeWebApplication.this.readFile(string);
            }
        });
        wVBoxLayout.addWidget((WWidget)fileUploadWidget);
        this.treeWidget = new TreeWidget();
        wVBoxLayout.addWidget((WWidget)this.treeWidget, 1);
        this.treeWidget.setStyleClass("tree");
        this.readFile("/etc/figtree/example.tree");
        this.tipPainter = new SimpleLabelPainter(LabelPainter.PainterIntent.TIP);
        this.treeWidget.getTreePane().setTipLabelPainter(this.tipPainter);
        this.nodePainter = new SimpleLabelPainter(LabelPainter.PainterIntent.NODE);
        this.treeWidget.getTreePane().setNodeLabelPainter(this.nodePainter);
        this.branchPainter = new SimpleLabelPainter(LabelPainter.PainterIntent.BRANCH);
        this.treeWidget.getTreePane().setBranchLabelPainter(this.branchPainter);
        this.createControls(wVBoxLayout);
    }

    private void readFile(String string) {
        try {
            FileReader fileReader = new FileReader(string);
            this.readData(fileReader, true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void createControls(WVBoxLayout wVBoxLayout) {
        WHBoxLayout wHBoxLayout = new WHBoxLayout();
        wVBoxLayout.addLayout((WLayout)wHBoxLayout, 0, AlignmentFlag.AlignJustify, new AlignmentFlag[]{AlignmentFlag.AlignTop});
        WVBoxLayout wVBoxLayout2 = new WVBoxLayout();
        wHBoxLayout.addLayout((WLayout)wVBoxLayout2, 0, AlignmentFlag.AlignJustify, new AlignmentFlag[]{AlignmentFlag.AlignMiddle});
        WComboBox wComboBox = new WComboBox();
        this.addField((WBoxLayout)wVBoxLayout2, "Layout: ", (WFormWidget)wComboBox, AlignmentFlag.AlignLeft);
        wComboBox.addItem((CharSequence)"Rectilinear");
        wComboBox.addItem((CharSequence)"Radial");
        wComboBox.addItem((CharSequence)"Polar");
        wComboBox.activated().addListener((WObject)this, (Signal1.Listener)new Signal1.Listener<Integer>(){

            public void trigger(Integer n) {
                switch (n) {
                    case 0: {
                        FigTreeWebApplication.this.treeWidget.getTreePane().setTreeLayout(new RectilinearTreeLayout());
                        break;
                    }
                    case 1: {
                        FigTreeWebApplication.this.treeWidget.getTreePane().setTreeLayout(new RadialTreeLayout());
                        break;
                    }
                    case 2: {
                        FigTreeWebApplication.this.treeWidget.getTreePane().setTreeLayout(new PolarTreeLayout());
                    }
                }
            }
        });
        wVBoxLayout2 = new WVBoxLayout();
        wHBoxLayout.addLayout((WLayout)wVBoxLayout2, 0, AlignmentFlag.AlignJustify, new AlignmentFlag[]{AlignmentFlag.AlignMiddle});
        WSpinBox wSpinBox = new WSpinBox();
        wSpinBox.setValue(2.0);
        wSpinBox.setRange(0.0, 48.0);
        wSpinBox.setMaxLength(3);
        this.addField((WBoxLayout)wVBoxLayout2, "Line Weight: ", (WFormWidget)wSpinBox, AlignmentFlag.AlignRight);
        wSpinBox.valueChanged().addListener((WObject)this, (Signal1.Listener)new Signal1.Listener<Double>(){

            public void trigger(Double d) {
                FigTreeWebApplication.this.treeWidget.getTreePane().setBranchStroke(new BasicStroke(d.floatValue()));
            }
        });
        wSpinBox.valueChanged().trigger((Object)wSpinBox.getValue());
        wSpinBox = new WSpinBox();
        wSpinBox.setValue(6.0);
        wSpinBox.setRange(0.0, 48.0);
        wSpinBox.setValidator((WValidator)new WIntValidator(0, 48));
        wSpinBox.setMaxLength(3);
        this.addField((WBoxLayout)wVBoxLayout2, "Font Size: ", (WFormWidget)wSpinBox, AlignmentFlag.AlignRight);
        wSpinBox.valueChanged().addListener((WObject)this, (Signal1.Listener)new Signal1.Listener<Double>(){

            public void trigger(Double d) {
                FigTreeWebApplication.this.tipPainter.setFont(new Font("sansserif", 0, d.intValue()));
            }
        });
        wSpinBox.valueChanged().trigger((Object)wSpinBox.getValue());
        wVBoxLayout2 = new WVBoxLayout();
        wHBoxLayout.addLayout((WLayout)wVBoxLayout2, 0, AlignmentFlag.AlignJustify, new AlignmentFlag[]{AlignmentFlag.AlignMiddle});
        final WCheckBox wCheckBox = new WCheckBox((CharSequence)"Midpoint root");
        wCheckBox.setChecked(false);
        this.addField((WBoxLayout)wVBoxLayout2, null, (WFormWidget)wCheckBox, AlignmentFlag.AlignRight);
        wCheckBox.changed().addListener((WObject)this, new Signal.Listener(){

            public void trigger() {
                if (wCheckBox.isChecked()) {
                    FigTreeWebApplication.this.treeWidget.getTreePane().setRootingOn(true);
                    FigTreeWebApplication.this.treeWidget.getTreePane().setRootingType(TreePane.RootingType.MID_POINT);
                } else {
                    FigTreeWebApplication.this.treeWidget.getTreePane().setRootingOn(false);
                    FigTreeWebApplication.this.treeWidget.getTreePane().setRootingType(TreePane.RootingType.USER_ROOTING);
                }
            }
        });
        final WComboBox wComboBox2 = new WComboBox();
        wComboBox2.addItem((CharSequence)"Off");
        wComboBox2.addItem((CharSequence)"Increasing");
        wComboBox2.addItem((CharSequence)"Decreasing");
        wComboBox2.resize(new WLength(120.0), WLength.Auto);
        this.addField((WBoxLayout)wVBoxLayout2, "Order: ", (WFormWidget)wComboBox2, AlignmentFlag.AlignRight);
        wComboBox2.changed().addListener((WObject)this, new Signal.Listener(){

            public void trigger() {
                if (wComboBox2.getCurrentIndex() == 0) {
                    FigTreeWebApplication.this.treeWidget.getTreePane().setOrderBranchesOn(false);
                } else {
                    FigTreeWebApplication.this.treeWidget.getTreePane().setOrderBranchesOn(true);
                    FigTreeWebApplication.this.treeWidget.getTreePane().setBranchOrdering(SortedRootedTree.BranchOrdering.values()[wComboBox2.getCurrentIndex() - 1]);
                }
            }
        });
        final WComboBox wComboBox3 = new WComboBox();
        wComboBox3.addItem((CharSequence)"Off");
        wComboBox3.addItem((CharSequence)TransformedRootedTree.Transform.CLADOGRAM.toString());
        wComboBox3.addItem((CharSequence)TransformedRootedTree.Transform.PROPORTIONAL.toString());
        wComboBox3.addItem((CharSequence)TransformedRootedTree.Transform.EQUAL_LENGTHS.toString());
        wComboBox3.resize(new WLength(120.0), WLength.Auto);
        this.addField((WBoxLayout)wVBoxLayout2, "Transform: ", (WFormWidget)wComboBox3, AlignmentFlag.AlignRight);
        wComboBox3.changed().addListener((WObject)this, new Signal.Listener(){

            public void trigger() {
                if (wComboBox3.getCurrentIndex() == 0) {
                    FigTreeWebApplication.this.treeWidget.getTreePane().setTransformBranchesOn(false);
                } else {
                    FigTreeWebApplication.this.treeWidget.getTreePane().setTransformBranchesOn(true);
                    FigTreeWebApplication.this.treeWidget.getTreePane().setBranchTransform(TransformedRootedTree.Transform.values()[wComboBox3.getCurrentIndex() - 1]);
                }
            }
        });
        wVBoxLayout2 = new WVBoxLayout();
        wHBoxLayout.addLayout((WLayout)wVBoxLayout2, 0, AlignmentFlag.AlignJustify, new AlignmentFlag[]{AlignmentFlag.AlignMiddle});
        WComboBox wComboBox4 = this.addLabelCombo(wVBoxLayout2, this.tipPainter, "Tips: ");
        wComboBox4.setCurrentIndex(1);
        wComboBox4.changed().trigger();
        this.addLabelCombo(wVBoxLayout2, this.nodePainter, "Nodes: ");
        this.addLabelCombo(wVBoxLayout2, this.branchPainter, "Branches: ");
    }

    private WComboBox addLabelCombo(WVBoxLayout wVBoxLayout, final SimpleLabelPainter simpleLabelPainter, String string) {
        simpleLabelPainter.setNumberFormat(new DecimalFormat("#.####"));
        simpleLabelPainter.setFont(new Font("sansserif", 0, 8));
        String[] stringArray = simpleLabelPainter.getAttributes();
        final WComboBox wComboBox = new WComboBox();
        wComboBox.addItem((CharSequence)"None");
        for (String string2 : stringArray) {
            wComboBox.addItem((CharSequence)string2);
        }
        this.addField((WBoxLayout)wVBoxLayout, string, (WFormWidget)wComboBox, AlignmentFlag.AlignRight);
        wComboBox.changed().addListener((WObject)this, new Signal.Listener(){

            public void trigger() {
                String string = wComboBox.getCurrentText().toString();
                if (string.equals("none")) {
                    simpleLabelPainter.setVisible(false);
                } else {
                    simpleLabelPainter.setDisplayAttribute(string);
                    simpleLabelPainter.setVisible(true);
                }
            }
        });
        wComboBox.changed().trigger();
        return wComboBox;
    }

    private void addField(WBoxLayout wBoxLayout, String string, WFormWidget wFormWidget, AlignmentFlag alignmentFlag) {
        WContainerWidget wContainerWidget = new WContainerWidget();
        if (string != null) {
            WLabel wLabel = new WLabel((CharSequence)string);
            wContainerWidget.addWidget((WWidget)wLabel);
            wLabel.setBuddy(wFormWidget);
        }
        wContainerWidget.addWidget((WWidget)wFormWidget);
        wBoxLayout.addWidget((WWidget)wContainerWidget, 0, alignmentFlag, new AlignmentFlag[]{AlignmentFlag.AlignTop});
    }

    protected boolean readData(Reader reader, boolean bl) throws IOException {
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        try {
            if (bl) {
                FigTreeNexusImporter figTreeNexusImporter = new FigTreeNexusImporter(reader);
                while (figTreeNexusImporter.hasTree()) {
                    Tree tree = figTreeNexusImporter.importNextTree();
                    arrayList.add(tree);
                }
            } else {
                NewickImporter newickImporter = new NewickImporter(reader, true);
                while (newickImporter.hasTree()) {
                    Tree tree = newickImporter.importNextTree();
                    arrayList.add(tree);
                }
            }
            if (arrayList.size() == 0) {
                throw new ImportException("This file contained no trees.");
            }
            this.treeWidget.getTreePane().setTree((RootedTree)arrayList.get(0));
        }
        catch (ImportException importException) {
            return false;
        }
        return true;
    }
}

