/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.treelayouts;

import figtree.treeviewer.treelayouts.AbstractTreeLayout;
import figtree.treeviewer.treelayouts.TreeLayout;
import figtree.treeviewer.treelayouts.TreeLayoutCache;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.List;
import jebl.evolution.graphs.Graph;
import jebl.evolution.graphs.Node;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.Utils;

public class RadialTreeLayout
extends AbstractTreeLayout {
    private double spread = 0.0;

    @Override
    public TreeLayout.AxisType getXAxisType() {
        return TreeLayout.AxisType.CONTINUOUS;
    }

    @Override
    public TreeLayout.AxisType getYAxisType() {
        return TreeLayout.AxisType.CONTINUOUS;
    }

    @Override
    public boolean isShowingRootBranch() {
        return false;
    }

    public double getTotalRootLength() {
        return 0.0;
    }

    @Override
    public void setFishEye(double d) {
    }

    @Override
    public void setPointOfInterest(double d, double d2) {
    }

    @Override
    public boolean isShowingColouring() {
        return this.branchColouringAttribute != null;
    }

    @Override
    public boolean maintainAspectRatio() {
        return true;
    }

    @Override
    public double getHeightOfPoint(Point2D point2D) {
        throw new UnsupportedOperationException("Method getHeightOfPoint() is not supported in this TreeLayout");
    }

    @Override
    public Line2D getAxisLine(double d) {
        throw new UnsupportedOperationException("Method getHeightLine() is not supported in this TreeLayout");
    }

    @Override
    public Shape getHeightArea(double d, double d2) {
        throw new UnsupportedOperationException("Method getHeightArea() is not supported in this TreeLayout");
    }

    public double getSpread() {
        return this.spread;
    }

    public void setSpread(double d) {
        this.spread = d;
        this.fireTreeLayoutChanged();
    }

    @Override
    public void layout(RootedTree rootedTree, TreeLayoutCache treeLayoutCache) {
        treeLayoutCache.clear();
        try {
            Node node = rootedTree.getRootNode();
            this.constructNode(rootedTree, node, 0.0, Math.PI * 2, 0.0, 0.0, 0.0, treeLayoutCache);
        }
        catch (Graph.NoEdgeException noEdgeException) {
            noEdgeException.printStackTrace();
        }
    }

    private Point2D constructNode(RootedTree rootedTree, Node node, double d, double d2, double d3, double d4, double d5, TreeLayoutCache treeLayoutCache) throws Graph.NoEdgeException {
        Object object;
        Object object2;
        double d6 = (d + d2) / 2.0;
        double d7 = Math.cos(d6);
        double d8 = Math.sin(d6);
        Point2D.Double double_ = new Point2D.Double(d3 + d5 * d7, d4 + d5 * d8);
        if (!rootedTree.isExternal(node)) {
            Object object3;
            object2 = rootedTree.getChildren(node);
            object = new int[object2.size()];
            int n = 0;
            int n2 = 0;
            Iterator<Node> iterator = object2.iterator();
            while (iterator.hasNext()) {
                Node node2 = iterator.next();
                object[n2] = Utils.getExternalNodeCount(rootedTree, node2);
                n += object[n2];
                ++n2;
            }
            double d9 = d2 - d;
            if (!rootedTree.isRoot(node)) {
                d = d6 - (d9 *= 1.0 + this.spread / 10.0) / 2.0;
                d2 = d6 + d9 / 2.0;
            }
            double d10 = d;
            boolean bl = false;
            if (node.getAttribute("!rotate") != null && ((Boolean)node.getAttribute("!rotate")).booleanValue()) {
                bl = true;
            }
            for (n2 = 0; n2 < object2.size(); ++n2) {
                int n3 = n2;
                if (bl) {
                    n3 = object2.size() - n2 - 1;
                }
                object3 = (Node)object2.get(n3);
                double d11 = rootedTree.getLength((Node)object3);
                double d12 = d10;
                d10 = d12 + d9 * (double)object[n3] / (double)n;
                Point2D point2D = this.constructNode(rootedTree, (Node)object3, d12, d10, ((Point2D)double_).getX(), ((Point2D)double_).getY(), d11, treeLayoutCache);
                Line2D.Double double_2 = new Line2D.Double(point2D.getX(), point2D.getY(), ((Point2D)double_).getX(), ((Point2D)double_).getY());
                Object[] objectArray = null;
                if (this.branchColouringAttribute != null) {
                    objectArray = (Object[])object3.getAttribute(this.branchColouringAttribute);
                }
                if (objectArray != null) {
                    float f = (float)rootedTree.getHeight(node);
                    float f2 = (float)rootedTree.getHeight((Node)object3);
                    float f3 = (float)point2D.getX();
                    float f4 = (float)point2D.getY();
                    float f5 = (float)((Point2D)double_).getX();
                    float f6 = (float)((Point2D)double_).getY();
                    GeneralPath generalPath = new GeneralPath();
                    generalPath.moveTo(f3, f4);
                    float f7 = 0.0f;
                    for (int i = 0; i < objectArray.length - 1; i += 2) {
                        float f8 = (f7 += ((Number)objectArray[i + 1]).floatValue()) / (f - f2);
                        float f9 = f3 + (f5 - f3) * f8;
                        float f10 = f4 + (f6 - f4) * f8;
                        generalPath.lineTo(f9, f10);
                    }
                    generalPath.lineTo(f5, f6);
                    treeLayoutCache.branchPaths.put((Node)object3, generalPath);
                } else {
                    treeLayoutCache.branchPaths.put((Node)object3, double_2);
                }
                treeLayoutCache.branchLabelPaths.put((Node)object3, (Line2D)double_2.clone());
            }
            Point2D.Double double_3 = new Point2D.Double(d3 + (d5 + 1.0) * d7, d4 + (d5 + 1.0) * d8);
            object3 = new Line2D.Double(double_, double_3);
            treeLayoutCache.nodeLabelPaths.put(node, (Line2D)object3);
        } else {
            object2 = new Point2D.Double(d3 + (d5 + 1.0) * d7, d4 + (d5 + 1.0) * d8);
            object = new Line2D.Double(double_, (Point2D)object2);
            treeLayoutCache.tipLabelPaths.put(node, (Line2D)object);
        }
        object2 = new Point2D.Double(d3 + (d5 - 1.0) * d7, d4 + (d5 - 1.0) * d8);
        object = new Line2D.Double(double_, (Point2D)object2);
        treeLayoutCache.nodeShapePaths.put(node, (Line2D)object);
        treeLayoutCache.nodePoints.put(node, double_);
        return double_;
    }

    private void constructNodeAreas(RootedTree rootedTree, Node node, Area area, TreeLayoutCache treeLayoutCache) {
        if (!rootedTree.isExternal(node)) {
            List<Node> list = rootedTree.getChildren(node);
            boolean bl = false;
            if (node.getAttribute("!rotate") != null && ((Boolean)node.getAttribute("!rotate")).booleanValue()) {
                bl = true;
            }
            int n = bl ? list.size() - 1 : 0;
            Node node2 = list.get(n);
            Area area2 = new Area();
            this.constructNodeAreas(rootedTree, node2, area2, treeLayoutCache);
            n = bl ? 0 : list.size() - 1;
            Node node3 = list.get(n);
            Area area3 = new Area();
            this.constructNodeAreas(rootedTree, node3, area3, treeLayoutCache);
            GeneralPath generalPath = new GeneralPath();
            Line2D line2D = (Line2D)treeLayoutCache.getBranchPath(node2);
            Line2D line2D2 = (Line2D)treeLayoutCache.getBranchPath(node3);
            generalPath.moveTo(line2D2.getX1(), line2D2.getY1());
            generalPath.lineTo(line2D2.getX2(), line2D2.getY2());
            generalPath.lineTo(line2D.getX1(), line2D.getY1());
            generalPath.closePath();
            Area area4 = new Area(generalPath);
            area.add(area4);
            area.add(area2);
            area.add(area3);
            area4.subtract(area2);
            area4.subtract(area3);
            treeLayoutCache.nodeAreas.put(node, area4);
        }
    }

    private void constructHilight(RootedTree rootedTree, Node node, double d, double d2, double d3, double d4, double d5, TreeLayoutCache treeLayoutCache) {
        Object[] objectArray = (Object[])node.getAttribute(this.hilightAttributeName);
        int n = (Integer)objectArray[0];
        double d6 = (Double)objectArray[1];
        double d7 = rootedTree.getHeight(node);
        GeneralPath generalPath = new GeneralPath();
        double d8 = (d + d2) / 2.0;
        float f = (float)(d3 + 0.5 * d5 * Math.cos(d8));
        float f2 = (float)(d4 + 0.5 * d5 * Math.sin(d8));
        float f3 = (float)((double)f + d6 * Math.cos(d));
        float f4 = (float)((double)f2 + d6 * Math.sin(d));
        float f5 = (float)((double)f + d6 * Math.cos(d2));
        float f6 = (float)((double)f2 + d6 * Math.sin(d2));
        generalPath.moveTo(f, f2);
        generalPath.lineTo(f3, f4);
        generalPath.lineTo(f5, f6);
        generalPath.lineTo(f, f2);
        generalPath.closePath();
        treeLayoutCache.hilightNodes.add(node);
        treeLayoutCache.hilightShapes.put(node, generalPath);
    }
}

