/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.treelayouts;

import figtree.treeviewer.ControllerOptionsPanel;
import figtree.treeviewer.treelayouts.PolarTreeLayout;
import jam.controlpalettes.AbstractController;
import jam.panels.OptionsPanel;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PolarTreeLayoutController
extends AbstractController {
    private static final String POLAR_LAYOUT_KEY = "polarLayout";
    private static final String ROOT_ANGLE_KEY = "rootAngle";
    private static final String ANGULAR_RANGE_KEY = "angularRange";
    private static final String ROOT_LENGTH_KEY = "rootLength";
    private static final String SHOW_ROOT_KEY = "showRoot";
    private static final String ALIGN_TIP_LABELS_KEY = "alignTipLabels";
    private final JLabel titleLabel;
    private final OptionsPanel optionsPanel;
    private final JSlider rootAngleSlider;
    private final JSlider rootLengthSlider;
    private final JSlider angularRangeSlider;
    private final JCheckBox alignTipLabelsCheck;
    private final JCheckBox showRootCheck;
    private final PolarTreeLayout treeLayout;

    public PolarTreeLayoutController(final PolarTreeLayout polarTreeLayout) {
        this.treeLayout = polarTreeLayout;
        this.titleLabel = new JLabel("Polar Layout");
        this.optionsPanel = new ControllerOptionsPanel(0, 0);
        this.rootAngleSlider = new JSlider(0, 0, 360000, 0);
        this.rootAngleSlider.setOpaque(false);
        this.rootAngleSlider.setValue((int)(180.0 - polarTreeLayout.getRootAngle() * 1000.0));
        this.rootAngleSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                double d = 180.0 + (double)PolarTreeLayoutController.this.rootAngleSlider.getValue() / 1000.0;
                polarTreeLayout.setRootAngle(d % 360.0);
            }
        });
        this.optionsPanel.addComponentWithLabel("Root Angle:", this.rootAngleSlider, true);
        this.angularRangeSlider = new JSlider(0, 0, 360000, 0);
        this.angularRangeSlider.setOpaque(false);
        this.angularRangeSlider.setValue((int)(360.0 - polarTreeLayout.getAngularRange() * 1000.0));
        this.angularRangeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                double d = 360.0 - (double)PolarTreeLayoutController.this.angularRangeSlider.getValue() / 1000.0;
                polarTreeLayout.setAngularRange(d);
            }
        });
        this.optionsPanel.addComponentWithLabel("Angle Range:", this.angularRangeSlider, true);
        this.rootLengthSlider = new JSlider(0, 0, 10000, 0);
        this.rootLengthSlider.setOpaque(false);
        this.rootLengthSlider.setValue((int)(polarTreeLayout.getRootLengthProportion() * 10000.0));
        this.rootLengthSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                double d = PolarTreeLayoutController.this.rootLengthSlider.getValue();
                polarTreeLayout.setRootLengthProportion(d / 10000.0);
            }
        });
        this.optionsPanel.addComponentWithLabel("Root Length:", this.rootLengthSlider, true);
        this.showRootCheck = new JCheckBox("Show Root");
        this.showRootCheck.setOpaque(false);
        this.optionsPanel.addComponent(this.showRootCheck);
        this.showRootCheck.setSelected(polarTreeLayout.isShowingRootBranch());
        this.showRootCheck.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                polarTreeLayout.setShowingRootBranch(PolarTreeLayoutController.this.showRootCheck.isSelected());
            }
        });
        this.alignTipLabelsCheck = new JCheckBox("Align Tip Labels");
        this.alignTipLabelsCheck.setOpaque(false);
        this.alignTipLabelsCheck.setSelected(polarTreeLayout.getTipLabelPosition() == PolarTreeLayout.TipLabelPosition.RADIAL);
        this.alignTipLabelsCheck.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                polarTreeLayout.setTipLabelPosition(PolarTreeLayoutController.this.alignTipLabelsCheck.isSelected() ? PolarTreeLayout.TipLabelPosition.RADIAL : PolarTreeLayout.TipLabelPosition.FLUSH);
            }
        });
        this.optionsPanel.addSpanningComponent(this.alignTipLabelsCheck);
    }

    @Override
    public JComponent getTitleComponent() {
        return this.titleLabel;
    }

    @Override
    public JPanel getPanel() {
        return this.optionsPanel;
    }

    @Override
    public boolean isInitiallyVisible() {
        return false;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void setSettings(Map<String, Object> map) {
        this.rootAngleSlider.setValue((Integer)map.get("polarLayout.rootAngle"));
        this.angularRangeSlider.setValue((Integer)map.get("polarLayout.angularRange"));
        this.rootLengthSlider.setValue((Integer)map.get("polarLayout.rootLength"));
        this.showRootCheck.setSelected((Boolean)map.get("polarLayout.showRoot"));
        this.alignTipLabelsCheck.setSelected((Boolean)map.get("polarLayout.alignTipLabels"));
    }

    @Override
    public void getSettings(Map<String, Object> map) {
        map.put("polarLayout.rootAngle", this.rootAngleSlider.getValue());
        map.put("polarLayout.angularRange", this.angularRangeSlider.getValue());
        map.put("polarLayout.rootLength", this.rootLengthSlider.getValue());
        map.put("polarLayout.showRoot", this.showRootCheck.isSelected());
        map.put("polarLayout.alignTipLabels", this.alignTipLabelsCheck.isSelected());
    }
}

