/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.painters;

import figtree.treeviewer.decorators.DiscreteColourDecorator;
import figtree.treeviewer.painters.BasicLabelPainter;
import figtree.treeviewer.painters.LabelPainter;
import figtree.treeviewer.painters.Painter;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import jebl.evolution.graphs.Node;
import jebl.evolution.trees.Tree;

public class StatesPainter
extends BasicLabelPainter {
    private String[] annotationNames = null;
    private DiscreteColourDecorator[] decorators;
    private double width;
    private double blockSize = 8.0;
    private double blockGap = 2.0;

    public StatesPainter(String[] stringArray, DiscreteColourDecorator[] discreteColourDecoratorArray) {
        super(LabelPainter.PainterIntent.TIP);
        this.annotationNames = stringArray;
        this.decorators = discreteColourDecoratorArray;
    }

    @Override
    public Rectangle2D calibrate(Graphics2D graphics2D, Node node) {
        super.calibrate(graphics2D, node);
        int n = this.annotationNames.length;
        this.blockSize = super.getPreferredHeight() * 0.8;
        this.blockGap = 1.0;
        this.width = (double)n * (this.blockSize + this.blockGap) + this.blockGap + this.blockGap;
        return new Rectangle2D.Double(0.0, 0.0, this.getPreferredWidth(), this.getPreferredHeight());
    }

    @Override
    public double getPreferredWidth() {
        return super.getPreferredWidth() + this.width;
    }

    @Override
    public void paint(Graphics2D graphics2D, Node node, Painter.Justification justification, Rectangle2D rectangle2D) {
        Tree tree = this.getTree();
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        float f = (float)this.getPreferredHeight() / 2.0f;
        switch (justification) {
            case FLUSH: 
            case LEFT: {
                super.paint(graphics2D, node, justification, (Rectangle2D)new Rectangle2D.Double(rectangle2D.getX() + this.width, rectangle2D.getY(), rectangle2D.getWidth() - this.width, rectangle2D.getHeight()));
                double d = this.blockGap;
                int n = 0;
                for (String string : this.annotationNames) {
                    Object object = tree.getTaxon(node).getAttribute(string);
                    if (object != null) {
                        this.decorators[n].setItem(object);
                        int n2 = ((Number)object).intValue();
                        Rectangle2D.Double double_ = new Rectangle2D.Double(d, (double)f - this.blockSize / 2.0, this.blockSize, this.blockSize);
                        graphics2D.setPaint(this.decorators[n].getPaint(Color.white));
                        graphics2D.fill(double_);
                        graphics2D.setPaint(Color.white);
                        graphics2D.setFont(new Font("helvetica", 0, 9));
                        FontMetrics fontMetrics = graphics2D.getFontMetrics();
                        graphics2D.drawString(Integer.toString(n2), (float)(d + 1.0), (float)((double)f - this.blockSize / 2.0 + (double)fontMetrics.getAscent() + 1.0));
                        graphics2D.setPaint(Color.black);
                        graphics2D.setFont(new Font("helvetica", 0, 9));
                        graphics2D.drawString(Integer.toString(n2), (float)d, (float)((double)f - this.blockSize / 2.0 + (double)fontMetrics.getAscent()));
                    }
                    d += this.blockSize + this.blockGap;
                    ++n;
                }
                break;
            }
            case RIGHT: {
                super.paint(graphics2D, node, justification, (Rectangle2D)new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() - this.width, rectangle2D.getHeight()));
                int n = 0;
                for (String string : this.annotationNames) {
                    double d = this.getPreferredWidth() - this.blockGap - this.blockSize;
                    Object object = tree.getTaxon(node).getAttribute(string);
                    if (object == null) continue;
                    this.decorators[n].setItem(object);
                    Rectangle2D.Double double_ = new Rectangle2D.Double(d, (double)f - this.blockSize / 2.0, this.blockSize, this.blockSize);
                    graphics2D.setPaint(this.decorators[n].getPaint(Color.white));
                    graphics2D.fill(double_);
                    d -= this.blockSize + this.blockGap;
                    ++n;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized alignment enum option");
            }
        }
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
    }
}

