/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.painters;

import figtree.treeviewer.ScaleAxis;
import figtree.treeviewer.TreePane;
import figtree.treeviewer.decorators.Decorator;
import figtree.treeviewer.painters.LabelPainter;
import figtree.treeviewer.painters.Painter;
import figtree.treeviewer.painters.ScalePainter;
import jam.controlpalettes.ControlPalette;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Set;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.Tree;
import jebl.util.Attributable;

public class ScaleBarPainter
extends LabelPainter<TreePane>
implements ScalePainter {
    private BasicStroke scaleBarStroke = new BasicStroke(1.0f, 0, 2);
    private ScaleBarType type = ScaleBarType.BAR;
    private ScaleAxis axis = new ScaleAxis(4, 4);
    private double scaleRange;
    private double topMargin = 4.0;
    private double bottomMargin = 4.0;
    private double userScaleRange = 0.0;
    private boolean automaticScale = true;
    private double preferredHeight;
    private double preferredWidth;
    private float yOffset;
    protected TreePane treePane;

    public ScaleBarPainter() {
        this(0.0);
    }

    public ScaleBarPainter(double d) {
        super(null);
        this.scaleRange = d;
        this.type = ScaleBarType.BAR;
    }

    @Override
    public void setTreePane(TreePane treePane) {
        this.treePane = treePane;
    }

    @Override
    public Rectangle2D calibrate(Graphics2D graphics2D, TreePane treePane) {
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.getFont());
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        double d = fontMetrics.getHeight();
        this.preferredWidth = treePane.getTreeScale() * this.scaleRange;
        this.preferredHeight = d + this.topMargin + this.bottomMargin + (double)this.scaleBarStroke.getLineWidth();
        this.yOffset = (float)((double)fontMetrics.getAscent() + this.topMargin + this.bottomMargin) + this.scaleBarStroke.getLineWidth();
        graphics2D.setFont(font);
        return new Rectangle2D.Double(0.0, 0.0, this.preferredWidth, this.preferredHeight);
    }

    @Override
    public void paint(Graphics2D graphics2D, TreePane treePane, Painter.Justification justification, Rectangle2D rectangle2D) {
        double d;
        double d2;
        float f;
        Font font = graphics2D.getFont();
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        if (this.getBackground() != null) {
            graphics2D.setPaint(this.getBackground());
            graphics2D.fill(rectangle2D);
        }
        if (this.getBorderPaint() != null && this.getBorderStroke() != null) {
            graphics2D.setPaint(this.getBorderPaint());
            graphics2D.setStroke(this.getBorderStroke());
            graphics2D.draw(rectangle2D);
        }
        graphics2D.setFont(this.getFont());
        String string = Double.toString(this.scaleRange);
        Rectangle2D rectangle2D2 = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
        switch (justification) {
            case CENTER: {
                f = (float)(rectangle2D.getX() + (rectangle2D.getWidth() - rectangle2D2.getWidth()) / 2.0);
                d2 = rectangle2D.getX() + (rectangle2D.getWidth() - this.preferredWidth) / 2.0;
                d = d2 + this.preferredWidth;
                break;
            }
            case FLUSH: 
            case LEFT: {
                f = (float)rectangle2D.getX();
                d2 = rectangle2D.getX();
                d = d2 + this.preferredWidth;
                break;
            }
            case RIGHT: {
                f = (float)(rectangle2D.getX() + rectangle2D.getWidth() - rectangle2D2.getWidth());
                d = rectangle2D.getX() + rectangle2D.getWidth();
                d2 = d - this.preferredWidth;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized alignment enum option");
            }
        }
        graphics2D.setPaint(this.getForeground());
        graphics2D.setStroke(this.getScaleBarStroke());
        graphics2D.draw(new Line2D.Double(d2, rectangle2D.getY() + this.topMargin, d, rectangle2D.getY() + this.topMargin));
        graphics2D.drawString(string, f, this.yOffset + (float)rectangle2D.getY());
        graphics2D.setFont(font);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
    }

    @Override
    public double getPreferredWidth() {
        return this.preferredWidth;
    }

    @Override
    public double getPreferredHeight() {
        return this.preferredHeight;
    }

    @Override
    public double getHeightBound() {
        return this.preferredHeight + (double)this.yOffset;
    }

    public ScaleBarType getType() {
        return this.type;
    }

    public void setType(ScaleBarType scaleBarType) {
        this.type = scaleBarType;
        this.firePainterChanged();
    }

    public BasicStroke getScaleBarStroke() {
        return this.scaleBarStroke;
    }

    public void setScaleBarStroke(BasicStroke basicStroke) {
        this.scaleBarStroke = basicStroke;
        this.firePainterChanged();
    }

    public double getScaleRange() {
        return this.scaleRange;
    }

    public void setScaleRange(double d) {
        this.userScaleRange = d;
        this.calculateScaleRange();
        this.firePainterChanged();
    }

    public void setAutomaticScale(boolean bl) {
        this.automaticScale = bl;
        this.calculateScaleRange();
        this.firePainterChanged();
    }

    public void setControlPalette(ControlPalette controlPalette) {
    }

    public void calculateScaleRange() {
        if (!this.automaticScale && this.userScaleRange != 0.0) {
            this.scaleRange = this.userScaleRange;
        } else {
            RootedTree rootedTree = this.treePane.getTree();
            if (rootedTree != null) {
                double d = rootedTree.getHeight(rootedTree.getRootNode());
                if (d == 0.0) {
                    this.scaleRange = 0.0;
                } else {
                    double d2 = d / 10.0;
                    double d3 = -(Math.ceil(Math.log10(d2)) - 1.0);
                    for (int i = 0; i < 3; ++i) {
                        double d4 = Math.pow(10.0, d3);
                        double d5 = (double)((int)(d2 * d4) + 1) / d4;
                        if (i == 2 || d5 < d / 5.0) {
                            this.scaleRange = d5;
                            break;
                        }
                        d3 += 1.0;
                    }
                }
            }
        }
    }

    public String[] getAttributes() {
        return new String[0];
    }

    public void setupAttributes(Collection<? extends Tree> collection) {
    }

    @Override
    public String getDisplayAttribute() {
        throw new UnsupportedOperationException("getDisplayAttribute not implmented");
    }

    @Override
    public void setDisplayAttribute(String string) {
        throw new UnsupportedOperationException("setDisplayAttribute not implemented in ScaleBarPainter");
    }

    @Override
    public void setTextDecorator(Decorator decorator) {
    }

    public Set<Attributable> getAttributableItems() {
        return null;
    }

    public static enum ScaleBarType {
        BAR,
        AXIS;

    }
}

