/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.painters;

import figtree.treeviewer.decorators.Decorator;
import figtree.treeviewer.painters.AbstractPainter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.NumberFormat;

public abstract class LabelPainter<T>
extends AbstractPainter<T> {
    public static final String NAMES = "Names";
    public static final String NODE_AGES = "Node ages";
    public static final String NODE_HEIGHTS = "Node heights (raw)";
    public static final String BRANCH_TIMES = "Branch times";
    public static final String BRANCH_LENGTHS = "Branch lengths (raw)";
    private Paint foreground = Color.BLACK;
    private Paint background = null;
    private Paint borderPaint = null;
    private Stroke borderStroke = null;
    private Font font;
    private boolean visible = true;
    private NumberFormat numberFormat = null;
    private final PainterIntent intent;

    protected LabelPainter(PainterIntent painterIntent) {
        this.intent = painterIntent;
    }

    public abstract String getDisplayAttribute();

    public abstract void setDisplayAttribute(String var1);

    public abstract void setTextDecorator(Decorator var1);

    public Paint getForeground() {
        return this.foreground;
    }

    public Paint getBackground() {
        return this.background;
    }

    public Paint getBorderPaint() {
        return this.borderPaint;
    }

    public Stroke getBorderStroke() {
        return this.borderStroke;
    }

    public Font getFont() {
        return this.font;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void setBackground(Paint paint) {
        this.background = paint;
        this.firePainterChanged();
    }

    public void setBorder(Paint paint, Stroke stroke) {
        this.borderPaint = paint;
        this.borderStroke = stroke;
        this.firePainterChanged();
    }

    public void setFont(Font font) {
        this.font = font;
        this.firePainterChanged();
    }

    public void setForeground(Paint paint) {
        this.foreground = paint;
        this.firePainterChanged();
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
        this.firePainterChanged();
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
        this.firePainterChanged();
    }

    public PainterIntent getIntent() {
        return this.intent;
    }

    public static enum PainterIntent {
        NODE,
        BRANCH,
        TIP,
        RANGE;

    }
}

