/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.painters;

import figtree.treeviewer.painters.BasicLabelPainter;
import figtree.treeviewer.painters.LabelPainter;
import figtree.treeviewer.painters.Painter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import jebl.evolution.alignments.Alignment;
import jebl.evolution.graphs.Node;
import jebl.evolution.sequences.AminoAcids;
import jebl.evolution.sequences.Sequence;
import jebl.evolution.trees.Tree;

public class CharactersPainter
extends BasicLabelPainter {
    private Alignment characters = null;
    private double width;
    private double blockSize = 6.0;
    private double blockGap = 2.0;
    Paint[] paints = new Paint[AminoAcids.getStateCount()];

    public CharactersPainter(Alignment alignment) {
        super(LabelPainter.PainterIntent.TIP);
        this.characters = alignment;
        this.paints[AminoAcids.A_STATE.getIndex()] = new Color(204, 255, 255);
        this.paints[AminoAcids.C_STATE.getIndex()] = new Color(0, 255, 255);
        this.paints[AminoAcids.D_STATE.getIndex()] = new Color(255, 204, 153);
        this.paints[AminoAcids.E_STATE.getIndex()] = new Color(255, 204, 0);
        this.paints[AminoAcids.F_STATE.getIndex()] = new Color(0, 204, 255);
        this.paints[AminoAcids.G_STATE.getIndex()] = new Color(0, 255, 0);
        this.paints[AminoAcids.H_STATE.getIndex()] = new Color(255, 255, 153);
        this.paints[AminoAcids.I_STATE.getIndex()] = new Color(0, 0, 128);
        this.paints[AminoAcids.K_STATE.getIndex()] = new Color(198, 66, 0);
        this.paints[AminoAcids.L_STATE.getIndex()] = new Color(51, 102, 255);
        this.paints[AminoAcids.M_STATE.getIndex()] = new Color(153, 204, 255);
        this.paints[AminoAcids.N_STATE.getIndex()] = new Color(255, 153, 0);
        this.paints[AminoAcids.P_STATE.getIndex()] = new Color(255, 255, 0);
        this.paints[AminoAcids.Q_STATE.getIndex()] = new Color(255, 102, 0);
        this.paints[AminoAcids.R_STATE.getIndex()] = new Color(230, 6, 6);
        this.paints[AminoAcids.S_STATE.getIndex()] = new Color(204, 255, 153);
        this.paints[AminoAcids.T_STATE.getIndex()] = new Color(0, 255, 153);
        this.paints[AminoAcids.V_STATE.getIndex()] = new Color(0, 0, 255);
        this.paints[AminoAcids.W_STATE.getIndex()] = new Color(204, 153, 255);
        this.paints[AminoAcids.Y_STATE.getIndex()] = new Color(204, 255, 204);
        this.paints[AminoAcids.B_STATE.getIndex()] = Color.DARK_GRAY;
        this.paints[AminoAcids.Z_STATE.getIndex()] = Color.DARK_GRAY;
        this.paints[AminoAcids.X_STATE.getIndex()] = Color.GRAY;
        this.paints[AminoAcids.UNKNOWN_STATE.getIndex()] = Color.GRAY;
        this.paints[AminoAcids.STOP_STATE.getIndex()] = Color.GRAY;
        this.paints[AminoAcids.GAP_STATE.getIndex()] = Color.GRAY;
    }

    @Override
    public Rectangle2D calibrate(Graphics2D graphics2D, Node node) {
        super.calibrate(graphics2D, node);
        int n = this.characters.getSiteCount();
        this.blockSize = super.getPreferredHeight() / 2.0;
        this.blockGap = this.blockSize / 2.0;
        this.width = (double)n * (this.blockSize + this.blockGap) + this.blockGap + this.blockGap;
        return new Rectangle2D.Double(0.0, 0.0, this.getPreferredWidth(), this.getPreferredHeight());
    }

    @Override
    public double getPreferredWidth() {
        return super.getPreferredWidth() + this.width;
    }

    @Override
    public void paint(Graphics2D graphics2D, Node node, Painter.Justification justification, Rectangle2D rectangle2D) {
        Tree tree = this.getTree();
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        float f = (float)this.getPreferredHeight() / 2.0f;
        switch (justification) {
            case FLUSH: 
            case LEFT: {
                super.paint(graphics2D, node, justification, (Rectangle2D)new Rectangle2D.Double(rectangle2D.getX() + this.width, rectangle2D.getY(), rectangle2D.getWidth() - this.width, rectangle2D.getHeight()));
                Sequence sequence = this.characters.getSequence(tree.getTaxon(node));
                if (sequence == null) break;
                double d = this.blockGap;
                for (byte by : sequence.getStateIndices()) {
                    if (by != AminoAcids.GAP_STATE.getIndex()) {
                        Rectangle2D.Double double_ = new Rectangle2D.Double(d, (double)f - this.blockSize / 2.0, this.blockSize, this.blockSize);
                        graphics2D.setPaint(this.getStatePaint(by));
                        graphics2D.fill(double_);
                    }
                    d += this.blockSize + this.blockGap;
                }
                break;
            }
            case RIGHT: {
                super.paint(graphics2D, node, justification, (Rectangle2D)new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() - this.width, rectangle2D.getHeight()));
                Sequence sequence = this.characters.getSequence(tree.getTaxon(node));
                if (sequence == null) break;
                double d = this.getPreferredWidth() - this.blockGap - this.blockSize;
                for (byte by : sequence.getStateIndices()) {
                    Rectangle2D.Double double_ = new Rectangle2D.Double(d, (double)f - this.blockSize / 2.0, this.blockSize, this.blockSize);
                    graphics2D.setPaint(this.getStatePaint(by));
                    graphics2D.fill(double_);
                    d -= this.blockSize + this.blockGap;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized alignment enum option");
            }
        }
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
    }

    public Paint getStatePaint(int n) {
        return this.paints[n];
    }
}

