/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.painters;

import figtree.treeviewer.painters.Painter;
import figtree.treeviewer.painters.PainterListener;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractPainter<T>
implements Painter<T> {
    private final List<PainterListener> listeners = new ArrayList<PainterListener>();

    @Override
    public void addPainterListener(PainterListener painterListener) {
        this.listeners.add(painterListener);
    }

    @Override
    public void removePainterListener(PainterListener painterListener) {
        this.listeners.remove(painterListener);
    }

    public void firePainterChanged() {
        for (PainterListener painterListener : this.listeners) {
            painterListener.painterChanged();
        }
    }

    public void firePainterSettingsChanged() {
        for (PainterListener painterListener : this.listeners) {
            painterListener.painterSettingsChanged();
        }
    }

    public void fireAttributesChanged() {
        for (PainterListener painterListener : this.listeners) {
            painterListener.attributesChanged();
        }
    }
}

