/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.decorators;

import java.util.Set;
import java.util.TreeSet;
import jebl.util.Attributable;

public class ContinuousScale {
    private boolean normalize;
    private boolean logarithm;
    private double lowerRange;
    private double upperRange;
    private String attributeName = null;
    private double minValue = Double.MAX_VALUE;
    private double maxValue = Double.MIN_VALUE;

    public ContinuousScale(String string) {
        String[] stringArray;
        if (string.startsWith("{")) {
            string = string.substring(1, string.length());
        }
        if (string.endsWith("}")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((stringArray = string.split("[, ]+")).length != 4) {
            throw new IllegalArgumentException("ContinousScale settings string not in correct format");
        }
        try {
            this.normalize = Boolean.parseBoolean(stringArray[0]);
            this.logarithm = Boolean.parseBoolean(stringArray[1]);
            this.lowerRange = Double.parseDouble(stringArray[2]);
            this.upperRange = Double.parseDouble(stringArray[3]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("ContinousScale settings string not in correct format");
        }
    }

    public ContinuousScale() {
        this(false, 0.0, 0.0, false);
    }

    public ContinuousScale(boolean bl, double d, double d2, boolean bl2) {
        this.normalize = bl;
        this.lowerRange = d;
        this.upperRange = d2;
        this.logarithm = bl2;
    }

    public ContinuousScale(String string, Set<? extends Attributable> set) {
        this();
        this.setAttributes(string, set);
    }

    public void setAttributes(String string, Set<? extends Attributable> set) {
        this.attributeName = string;
        TreeSet<Object> treeSet = new TreeSet<Object>();
        for (Attributable object : set) {
            Object object2 = object.getAttribute(string);
            if (object2 == null) continue;
            treeSet.add(object2);
        }
        boolean bl = true;
        for (Object object2 : treeSet) {
            double d = -1.0;
            if (object2 instanceof Boolean) {
                d = (Boolean)object2 != false ? 1 : 0;
            } else if (object2 instanceof Number) {
                d = ((Number)object2).doubleValue();
            } else if (object2 instanceof String) {
                if (object2.toString().equalsIgnoreCase("true")) {
                    d = 1.0;
                } else if (object2.toString().equalsIgnoreCase("false")) {
                    d = 0.0;
                } else {
                    try {
                        d = Double.parseDouble(object2.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                }
            }
            if (!bl) continue;
            if (d < this.minValue) {
                this.minValue = d;
            }
            if (!(d > this.maxValue)) continue;
            this.maxValue = d;
        }
        if (!bl) {
            throw new NumberFormatException("One or more values for this attribute are not numbers");
        }
        if (this.normalize && this.minValue < 0.0 && this.maxValue > 0.0) {
            this.minValue = -this.maxValue;
        }
        if (this.logarithm) {
            if (this.minValue <= 0.0) {
                throw new NumberFormatException("One or more values for this attribute are negative or zero under a log scale");
            }
            this.minValue = Math.log(this.minValue);
            this.maxValue = Math.log(this.maxValue);
        }
    }

    public double getValue(Attributable attributable) {
        return this.getValue(attributable.getAttribute(this.attributeName));
    }

    public double getValue(Object object) {
        if (object != null) {
            double d = 0.0;
            d = object instanceof Number ? ((Number)object).doubleValue() : Double.parseDouble(object.toString());
            return this.scaleValue(d);
        }
        return Double.NaN;
    }

    public double scaleValue(double d) {
        if (this.logarithm) {
            d = Math.log(d);
        }
        double d2 = this.getMinValue();
        double d3 = this.getMaxValue();
        return (d - d2) / (d3 - d2);
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public boolean isNormalize() {
        return this.normalize;
    }

    public void setNormalize(boolean bl) {
        this.normalize = bl;
    }

    public boolean isLogarithm() {
        return this.logarithm;
    }

    public void setLogarithm(boolean bl) {
        this.logarithm = bl;
    }

    public double getLowerRange() {
        return this.lowerRange;
    }

    public void setLowerRange(double d) {
        this.lowerRange = d;
    }

    public double getUpperRange() {
        return this.upperRange;
    }

    public void setUpperRange(double d) {
        this.upperRange = d;
    }

    public double getMinValue() {
        double d = this.minValue;
        if (this.normalize && this.lowerRange < this.minValue) {
            d = this.lowerRange;
        }
        return d;
    }

    public double getMaxValue() {
        double d = this.maxValue;
        if (this.normalize && this.upperRange > this.maxValue) {
            d = this.upperRange;
        }
        return d;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        stringBuilder.append(this.normalize);
        stringBuilder.append(",");
        stringBuilder.append(this.logarithm);
        stringBuilder.append(",");
        stringBuilder.append(this.lowerRange);
        stringBuilder.append(",");
        stringBuilder.append(this.upperRange);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

