/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer;

import figtree.treeviewer.TreeViewer;
import figtree.treeviewer.annotations.AnnotationDefinition;
import figtree.ui.components.RealNumberField;
import figtree.ui.components.WholeNumberField;
import jam.panels.OptionsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class FindDialog {
    private JFrame frame;
    private JComboBox targetCombo = null;
    private JComboBox textSearchCombo = new JComboBox<TreeViewer.TextSearchType>(TreeViewer.TextSearchType.values());
    private JComboBox numberSearchCombo = new JComboBox<TreeViewer.NumberSearchType>(TreeViewer.NumberSearchType.values());
    private AnnotationDefinition.Type type = AnnotationDefinition.Type.STRING;
    private JTextField searchText = new JTextField();
    private RealNumberField doubleText = new RealNumberField();
    private WholeNumberField integerText = new WholeNumberField();
    private JCheckBox caseSensitiveCheck = new JCheckBox("Case sensitive");
    private JCheckBox findAllCheck = new JCheckBox("Find all");
    private int selectedTargetIndex = 0;

    public FindDialog(JFrame jFrame) {
        this.frame = jFrame;
    }

    public int showDialog(List<AnnotationDefinition> list) {
        OptionsPanel optionsPanel = new OptionsPanel(12, 12);
        this.searchText.setColumns(18);
        final JPanel jPanel = new JPanel(new BorderLayout(6, 6));
        this.targetCombo = new JComboBox();
        this.targetCombo.addItem(Target.TAXON_LABEL);
        this.targetCombo.addItem(Target.BRANCH_LENGTH);
        this.targetCombo.addItem(Target.NODE_AGE);
        this.targetCombo.addItem(Target.ANY_ANNOTATION);
        for (AnnotationDefinition object2 : list) {
            this.targetCombo.addItem(object2);
        }
        jPanel.add((Component)this.targetCombo, "West");
        jPanel.add((Component)this.textSearchCombo, "Center");
        jPanel.add((Component)this.searchText, "East");
        optionsPanel.addComponent(jPanel);
        optionsPanel.addComponent(this.caseSensitiveCheck);
        JOptionPane jOptionPane = new JOptionPane(optionsPanel, 3, 2, null, null, null);
        jOptionPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        final JDialog jDialog = jOptionPane.createDialog(this.frame, "Find");
        jDialog.pack();
        this.targetCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = FindDialog.this.targetCombo.getSelectedItem();
                if (object.equals((Object)Target.BRANCH_LENGTH) || object.equals((Object)Target.NODE_AGE)) {
                    FindDialog.this.type = AnnotationDefinition.Type.REAL;
                } else if (object instanceof AnnotationDefinition) {
                    FindDialog.this.type = ((AnnotationDefinition)object).getType();
                } else {
                    FindDialog.this.type = AnnotationDefinition.Type.STRING;
                }
                jPanel.removeAll();
                jPanel.add((Component)FindDialog.this.targetCombo, "West");
                switch (FindDialog.this.type) {
                    case INTEGER: {
                        jPanel.add((Component)FindDialog.this.numberSearchCombo, "Center");
                        jPanel.add((Component)FindDialog.this.integerText, "East");
                        FindDialog.this.integerText.setColumns(10);
                        FindDialog.this.caseSensitiveCheck.setEnabled(false);
                        break;
                    }
                    case REAL: {
                        jPanel.add((Component)FindDialog.this.numberSearchCombo, "Center");
                        jPanel.add((Component)FindDialog.this.doubleText, "East");
                        FindDialog.this.doubleText.setColumns(10);
                        FindDialog.this.caseSensitiveCheck.setEnabled(false);
                        break;
                    }
                    default: {
                        jPanel.add((Component)FindDialog.this.textSearchCombo, "Center");
                        jPanel.add((Component)FindDialog.this.searchText, "East");
                        FindDialog.this.caseSensitiveCheck.setEnabled(true);
                    }
                }
                jDialog.pack();
            }
        });
        this.targetCombo.setSelectedIndex(this.selectedTargetIndex);
        jDialog.setVisible(true);
        int n = 2;
        Integer n2 = (Integer)jOptionPane.getValue();
        if (n2 != null && n2 != -1) {
            n = n2;
        }
        if (n == 0) {
            // empty if block
        }
        return n;
    }

    public Target getSearchTarget() {
        this.selectedTargetIndex = this.targetCombo.getSelectedIndex();
        Object object = this.targetCombo.getSelectedItem();
        if (object instanceof Target) {
            return (Target)((Object)object);
        }
        return Target.ANNOTATION;
    }

    public String getSearchTargetString() {
        return this.targetCombo.getSelectedItem().toString();
    }

    public boolean isNumericSearchType() {
        return this.type == AnnotationDefinition.Type.REAL || this.type == AnnotationDefinition.Type.INTEGER;
    }

    public TreeViewer.TextSearchType getTextSearchType() {
        return (TreeViewer.TextSearchType)((Object)this.textSearchCombo.getSelectedItem());
    }

    public TreeViewer.NumberSearchType getNumberSearchType() {
        return (TreeViewer.NumberSearchType)((Object)this.numberSearchCombo.getSelectedItem());
    }

    public String getSearchText() {
        return this.searchText.getText();
    }

    public boolean isCaseSensitive() {
        return this.caseSensitiveCheck.isSelected();
    }

    public Number getSearchValue() {
        if (this.type == AnnotationDefinition.Type.REAL) {
            return this.doubleText.getValue();
        }
        if (this.type == AnnotationDefinition.Type.INTEGER) {
            return this.integerText.getValue();
        }
        return null;
    }

    public static enum Target {
        TAXON_LABEL("Taxon Label"),
        BRANCH_LENGTH("Branch Length"),
        NODE_AGE("Node Age"),
        ANY_ANNOTATION("Any Annotation"),
        ANNOTATION("Annotation");

        private String name;

        private Target(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }
}

