/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer;

import figtree.treeviewer.decorators.ContinuousColourDecorator;
import figtree.treeviewer.decorators.ContinuousScale;
import figtree.treeviewer.decorators.HSBContinuousColourDecorator;
import figtree.treeviewer.decorators.InterpolatingColourDecorator;
import figtree.ui.components.ColorWellButton;
import figtree.ui.components.RangeSlider;
import figtree.ui.components.RealNumberField;
import jam.panels.OptionsPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ContinuousColourScaleDialog {
    private static final int SLIDER_RANGE = 1000;
    private static final String HSB_SPECTRUM = "HSB Spectrum";
    private static final String COLOUR_GRADIENT = "Colour Gradient";
    private JFrame frame;
    private JComboBox colourSchemeCombo = new JComboBox<String>(new String[]{"HSB Spectrum", "Colour Gradient"});
    CardLayout cardLayout = new CardLayout();
    private final JPanel colourSchemePanel;
    private Map<String, ColourSchemePanel> colourSchemeNamePanelMap = new HashMap<String, ColourSchemePanel>();
    private Map<Class, String> colourSchemeClassNameMap = new HashMap<Class, String>();
    private ContinuousColourDecorator decorator;
    private JComponent colourDisplay;
    private final JCheckBox autoScaleCheck;
    private final JLabel fromLabel;
    private final RealNumberField fromNumberField;
    private final JLabel toLabel;
    private final RealNumberField toNumberField;
    private JDialog dialog;

    public ContinuousColourScaleDialog(JFrame jFrame) {
        this.frame = jFrame;
        this.colourSchemeNamePanelMap.put(HSB_SPECTRUM, new HSBColourSchemePanel());
        this.colourSchemeNamePanelMap.put(COLOUR_GRADIENT, new InterpolatingColourSchemePanel());
        this.colourSchemeClassNameMap.put(HSBContinuousColourDecorator.class, HSB_SPECTRUM);
        this.colourSchemeClassNameMap.put(InterpolatingColourDecorator.class, COLOUR_GRADIENT);
        this.autoScaleCheck = new JCheckBox("Auto-scale range between min and max values");
        this.fromLabel = new JLabel("Range from:");
        this.fromNumberField = new RealNumberField();
        this.fromNumberField.setColumns(10);
        this.toLabel = new JLabel("to:");
        this.toNumberField = new RealNumberField();
        this.toNumberField.setColumns(10);
        this.autoScaleCheck.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = !ContinuousColourScaleDialog.this.autoScaleCheck.isSelected();
                ContinuousColourScaleDialog.this.fromLabel.setEnabled(bl);
                ContinuousColourScaleDialog.this.fromNumberField.setEnabled(bl);
                ContinuousColourScaleDialog.this.toLabel.setEnabled(bl);
                ContinuousColourScaleDialog.this.toNumberField.setEnabled(bl);
            }
        });
        this.colourSchemePanel = new JPanel(this.cardLayout);
        for (String string : this.colourSchemeNamePanelMap.keySet()) {
            ColourSchemePanel colourSchemePanel = this.colourSchemeNamePanelMap.get(string);
            this.colourSchemePanel.add((Component)colourSchemePanel.getPanel(), string);
        }
        this.colourSchemeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ContinuousColourScaleDialog.this.cardLayout.show(ContinuousColourScaleDialog.this.colourSchemePanel, ContinuousColourScaleDialog.this.colourSchemeCombo.getSelectedItem().toString());
                ContinuousColourScaleDialog.this.decorator = ((ColourSchemePanel)ContinuousColourScaleDialog.this.colourSchemeNamePanelMap.get(ContinuousColourScaleDialog.this.colourSchemeCombo.getSelectedItem())).getDecorator();
                ContinuousColourScaleDialog.this.colourDisplay.repaint();
                ContinuousColourScaleDialog.this.dialog.pack();
            }
        });
        this.colourDisplay = new JComponent(){
            private static final int MAX_HEIGHT = 20;

            @Override
            public void paint(Graphics graphics) {
                ContinuousColourDecorator continuousColourDecorator = ContinuousColourScaleDialog.this.getDecorator();
                Graphics2D graphics2D = (Graphics2D)graphics;
                Rectangle rectangle = this.getVisibleRect();
                int n = rectangle.width;
                rectangle.width = 1;
                ContinuousScale continuousScale = continuousColourDecorator.getContinuousScale();
                double d = continuousScale.getMinValue();
                double d2 = (continuousScale.getMaxValue() - d) / (double)n;
                for (int i = 0; i < n; ++i) {
                    graphics2D.setColor(continuousColourDecorator.getColourForValue(d));
                    graphics2D.fill(rectangle);
                    ++rectangle.x;
                    d += d2;
                }
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 20);
            }
        };
    }

    public int showDialog() {
        ContinuousColourDecorator continuousColourDecorator = this.getDecorator();
        OptionsPanel optionsPanel = new OptionsPanel(6, 6);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.colourDisplay, "Center");
        jPanel.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        optionsPanel.addSpanningComponent(jPanel);
        optionsPanel.addComponent(this.autoScaleCheck);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        jPanel2.add(this.fromLabel);
        jPanel2.add(this.fromNumberField);
        jPanel2.add(this.toLabel);
        jPanel2.add(this.toNumberField);
        optionsPanel.addComponent(jPanel2);
        optionsPanel.addComponentWithLabel("Scheme: ", this.colourSchemeCombo);
        this.colourSchemePanel.setBorder(BorderFactory.createBevelBorder(1));
        optionsPanel.addSpanningComponent(this.colourSchemePanel);
        JOptionPane jOptionPane = new JOptionPane(optionsPanel, 3, 2, null, null, null);
        jOptionPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialog = jOptionPane.createDialog(this.frame, "Setup colour range: " + continuousColourDecorator.getAttributeName());
        this.colourSchemeCombo.setSelectedItem(this.colourSchemeClassNameMap.get(this.decorator.getClass()));
        this.dialog.pack();
        this.dialog.setResizable(false);
        this.dialog.setVisible(true);
        int n = 2;
        Integer n2 = (Integer)jOptionPane.getValue();
        if (n2 != null && n2 != -1) {
            n = n2;
        }
        return n;
    }

    public void setDecorator(ContinuousColourDecorator continuousColourDecorator) {
        this.decorator = continuousColourDecorator;
        this.autoScaleCheck.setSelected(!continuousColourDecorator.getContinuousScale().isNormalize());
        this.fromNumberField.setValue(continuousColourDecorator.getContinuousScale().getLowerRange());
        this.toNumberField.setValue(continuousColourDecorator.getContinuousScale().getUpperRange());
        for (String string : this.colourSchemeNamePanelMap.keySet()) {
            this.colourSchemeNamePanelMap.get(string).setDecorator(continuousColourDecorator);
        }
    }

    public ContinuousColourDecorator getDecorator() {
        String string = this.colourSchemeCombo.getSelectedItem().toString();
        this.decorator = this.colourSchemeNamePanelMap.get(string).getDecorator();
        this.decorator.getContinuousScale().setNormalize(!this.autoScaleCheck.isSelected());
        this.decorator.getContinuousScale().setLowerRange(this.fromNumberField.getValue());
        this.decorator.getContinuousScale().setUpperRange(this.toNumberField.getValue());
        return this.decorator;
    }

    private class InterpolatingColourSchemePanel
    implements ColourSchemePanel {
        private ColorWellButton fromColourButton;
        private ColorWellButton toColourButton;
        private JCheckBox middleColourCheck = new JCheckBox("through:");
        private ColorWellButton middleColourButton;
        private InterpolatingColourDecorator interpolatingDecorator = null;
        private JPanel panel = null;

        public InterpolatingColourSchemePanel() {
            this.fromColourButton = new ColorWellButton(InterpolatingColourDecorator.DEFAULT_COLOR_1, "Choose Start Colour");
            this.toColourButton = new ColorWellButton(InterpolatingColourDecorator.DEFAULT_COLOR_2, "Choose End Colour");
            this.middleColourButton = new ColorWellButton(InterpolatingColourDecorator.DEFAULT_COLOR_3, "Choose Middle Colour");
            this.middleColourCheck.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    InterpolatingColourSchemePanel.this.middleColourButton.setEnabled(InterpolatingColourSchemePanel.this.middleColourCheck.isSelected());
                }
            });
            this.middleColourCheck.setSelected(false);
            this.middleColourButton.setEnabled(false);
        }

        @Override
        public void setDecorator(ContinuousColourDecorator continuousColourDecorator) {
            if (continuousColourDecorator instanceof InterpolatingColourDecorator) {
                this.interpolatingDecorator = (InterpolatingColourDecorator)continuousColourDecorator;
            } else if (this.interpolatingDecorator == null) {
                this.interpolatingDecorator = new InterpolatingColourDecorator(continuousColourDecorator.getContinuousScale());
            }
            this.fromColourButton.setSelectedColor(this.interpolatingDecorator.getColor1());
            if (this.interpolatingDecorator.getColor3() != null) {
                this.middleColourCheck.setSelected(true);
                this.middleColourButton.setSelectedColor(this.interpolatingDecorator.getColor2());
                this.toColourButton.setSelectedColor(this.interpolatingDecorator.getColor3());
            } else {
                this.middleColourCheck.setSelected(false);
                this.toColourButton.setSelectedColor(this.interpolatingDecorator.getColor2());
            }
        }

        @Override
        public ContinuousColourDecorator getDecorator() {
            if (this.middleColourCheck.isSelected()) {
                this.interpolatingDecorator.setColours(this.fromColourButton.getSelectedColor(), this.middleColourButton.getSelectedColor(), this.toColourButton.getSelectedColor());
            } else {
                this.interpolatingDecorator.setColours(this.fromColourButton.getSelectedColor(), this.toColourButton.getSelectedColor());
            }
            return this.interpolatingDecorator;
        }

        @Override
        public JPanel getPanel() {
            if (this.panel == null) {
                OptionsPanel optionsPanel = new OptionsPanel(6, 6);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new FlowLayout());
                jPanel.add(new JLabel("Colour gradient from:"));
                jPanel.add(this.fromColourButton);
                jPanel.add(new JLabel("to:"));
                jPanel.add(this.toColourButton);
                optionsPanel.addComponent(jPanel);
                JPanel jPanel2 = new JPanel();
                jPanel.setLayout(new FlowLayout());
                jPanel.add(this.middleColourCheck);
                jPanel.add(this.middleColourButton);
                optionsPanel.addComponent(jPanel2);
                this.panel = optionsPanel;
                ChangeListener changeListener = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        InterpolatingColourSchemePanel.this.getDecorator();
                        ContinuousColourScaleDialog.this.colourDisplay.repaint();
                    }
                };
                this.fromColourButton.addChangeListener(changeListener);
                this.toColourButton.addChangeListener(changeListener);
                this.middleColourCheck.addChangeListener(changeListener);
                this.middleColourButton.addChangeListener(changeListener);
            }
            return this.panel;
        }

        @Override
        public String getName() {
            return ContinuousColourScaleDialog.COLOUR_GRADIENT;
        }
    }

    private class HSBColourSchemePanel
    implements ColourSchemePanel {
        private RangeSlider hueSlider = new RangeSlider(0, 1000);
        private RangeSlider saturationSlider = new RangeSlider(0, 1000);
        private RangeSlider brightnessSlider = new RangeSlider(0, 1000);
        private JCheckBox reverseHueCheck = new JCheckBox("Reverse hue spectrum");
        private HSBContinuousColourDecorator hsbDecorator = null;
        private JPanel panel = null;

        @Override
        public void setDecorator(ContinuousColourDecorator continuousColourDecorator) {
            if (continuousColourDecorator instanceof HSBContinuousColourDecorator) {
                this.hsbDecorator = (HSBContinuousColourDecorator)continuousColourDecorator;
            } else if (this.hsbDecorator == null) {
                this.hsbDecorator = new HSBContinuousColourDecorator(continuousColourDecorator.getContinuousScale());
            }
            this.hueSlider.setValue((int)(this.hsbDecorator.getHueLower() * 1000.0f));
            this.hueSlider.setUpperValue((int)(this.hsbDecorator.getHueUpper() * 1000.0f));
            this.saturationSlider.setValue((int)(this.hsbDecorator.getSaturationLower() * 1000.0f));
            this.saturationSlider.setUpperValue((int)(this.hsbDecorator.getSaturationUpper() * 1000.0f));
            this.brightnessSlider.setValue((int)(this.hsbDecorator.getBrightnessLower() * 1000.0f));
            this.brightnessSlider.setUpperValue((int)(this.hsbDecorator.getBrightnessUpper() * 1000.0f));
            this.reverseHueCheck.setSelected(this.hsbDecorator.isReverseHue());
        }

        @Override
        public ContinuousColourDecorator getDecorator() {
            this.hsbDecorator.setHueLower((float)this.hueSlider.getValue() / 1000.0f);
            this.hsbDecorator.setHueUpper((float)this.hueSlider.getUpperValue() / 1000.0f);
            this.hsbDecorator.setSaturationLower((float)this.saturationSlider.getValue() / 1000.0f);
            this.hsbDecorator.setSaturationUpper((float)this.saturationSlider.getUpperValue() / 1000.0f);
            this.hsbDecorator.setBrightnessLower((float)this.brightnessSlider.getValue() / 1000.0f);
            this.hsbDecorator.setBrightnessUpper((float)this.brightnessSlider.getUpperValue() / 1000.0f);
            this.hsbDecorator.setReverseHue(this.reverseHueCheck.isSelected());
            return this.hsbDecorator;
        }

        @Override
        public JPanel getPanel() {
            if (this.panel == null) {
                OptionsPanel optionsPanel = new OptionsPanel(6, 6);
                optionsPanel.addComponentWithLabel("Hue: ", this.hueSlider);
                optionsPanel.addComponentWithLabel("Saturation: ", this.saturationSlider);
                optionsPanel.addComponentWithLabel("Brightness: ", this.brightnessSlider);
                optionsPanel.addComponent(this.reverseHueCheck);
                ChangeListener changeListener = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        HSBColourSchemePanel.this.getDecorator();
                        ContinuousColourScaleDialog.this.colourDisplay.repaint();
                    }
                };
                this.hueSlider.addChangeListener(changeListener);
                this.saturationSlider.addChangeListener(changeListener);
                this.brightnessSlider.addChangeListener(changeListener);
                this.reverseHueCheck.addChangeListener(changeListener);
                this.panel = optionsPanel;
            }
            return this.panel;
        }

        @Override
        public String getName() {
            return ContinuousColourScaleDialog.HSB_SPECTRUM;
        }
    }

    private static interface ColourSchemePanel {
        public void setDecorator(ContinuousColourDecorator var1);

        public ContinuousColourDecorator getDecorator();

        public JPanel getPanel();

        public String getName();
    }
}

