/*
 * Decompiled with CFR 0.152.
 */
package figtree.panel;

import figtree.treeviewer.treelayouts.RectilinearTreeLayout;
import jam.controlpalettes.AbstractController;
import jam.panels.OptionsPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TreeLayoutController
extends AbstractController {
    private static final String RECTILINEAR_LAYOUT_KEY = "rectilinearLayout";
    private static final String ALIGN_TIP_LABELS_KEY = "alignTipLabels";
    private final JLabel titleLabel = new JLabel("Rectangular Layout");
    private final OptionsPanel optionsPanel = new OptionsPanel();
    private final JCheckBox alignTipLabelsCheck = new JCheckBox("Align Tip Labels");

    public TreeLayoutController(final RectilinearTreeLayout rectilinearTreeLayout) {
        this.alignTipLabelsCheck.setOpaque(false);
        this.alignTipLabelsCheck.setSelected(rectilinearTreeLayout.isAlignTipLabels());
        this.alignTipLabelsCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                rectilinearTreeLayout.setAlignTipLabels(TreeLayoutController.this.alignTipLabelsCheck.isSelected());
            }
        });
        this.optionsPanel.addComponent(this.alignTipLabelsCheck);
    }

    @Override
    public JComponent getTitleComponent() {
        return this.titleLabel;
    }

    @Override
    public JPanel getPanel() {
        return this.optionsPanel;
    }

    @Override
    public boolean isInitiallyVisible() {
        return false;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void setSettings(Map<String, Object> map) {
        this.alignTipLabelsCheck.setSelected((Boolean)map.get("rectilinearLayout.alignTipLabels"));
    }

    @Override
    public void getSettings(Map<String, Object> map) {
        map.put("rectilinearLayout.alignTipLabels", this.alignTipLabelsCheck.isSelected());
    }
}

