/*
 * Decompiled with CFR 0.152.
 */
package figtree.panel;

import jam.controlpalettes.ControlPalette;
import jam.controlpalettes.ControlPaletteListener;
import jam.controlpalettes.Controller;
import jam.controlpalettes.ControllerListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class SimpleControlPalette
extends JPanel
implements ControlPalette {
    private ControllerListener controllerListener = new ControllerListener(){

        @Override
        public void controlsChanged() {
            SimpleControlPalette.this.layoutControls();
        }
    };
    private final List<ControlPaletteListener> listeners = new ArrayList<ControlPaletteListener>();
    private List<Controller> controllers = new ArrayList<Controller>();

    public SimpleControlPalette() {
        BoxLayout boxLayout = new BoxLayout(this, 2);
        this.setLayout(boxLayout);
        this.setOpaque(true);
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void addController(Controller controller) {
        this.controllers.add(controller);
        controller.addControllerListener(this.controllerListener);
        this.setupControls();
    }

    public void addController(int n, Controller controller) {
        this.controllers.add(n, controller);
        controller.addControllerListener(this.controllerListener);
        this.setupControls();
    }

    public void removeController(Controller controller) {
        controller.removeControllerListener(this.controllerListener);
        this.controllers.remove(controller);
        this.setupControls();
    }

    public int getControllerCount() {
        return this.controllers.size();
    }

    @Override
    public void fireControlsChanged() {
        for (ControlPaletteListener controlPaletteListener : this.listeners) {
            controlPaletteListener.controlsChanged();
        }
    }

    @Override
    public void addControlPaletteListener(ControlPaletteListener controlPaletteListener) {
        this.listeners.add(controlPaletteListener);
    }

    @Override
    public void removeControlPaletteListener(ControlPaletteListener controlPaletteListener) {
        this.listeners.remove(controlPaletteListener);
    }

    private void setupControls() {
        this.removeAll();
        for (Controller controller : this.controllers) {
            this.add(controller.getPanel());
        }
    }

    public void layoutControls() {
        this.validate();
    }

    @Override
    public void initialize() {
        for (Controller controller : this.controllers) {
            controller.initialize();
        }
    }

    @Override
    public void getSettings(Map<String, Object> map) {
        for (Controller controller : this.controllers) {
            controller.getSettings(map);
        }
    }

    @Override
    public void setSettings(Map<String, Object> map) {
        for (Controller controller : this.controllers) {
            controller.setSettings(map);
        }
    }

    @Override
    public void setPreferredWidth(int n) {
    }
}

