/*
 * Decompiled with CFR 0.152.
 */
package figtree.application;

import com.itextpdf.text.Document;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import figtree.application.Arguments;
import figtree.application.FigTreeNexusImporter;
import figtree.application.FigTreePanel;
import figtree.treeviewer.ExtendedTreeViewer;
import jam.controlpalettes.BasicControlPalette;
import java.awt.Graphics2D;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import jebl.evolution.io.ImportException;
import jebl.evolution.io.NewickImporter;
import jebl.evolution.io.NexusImporter;
import jebl.evolution.trees.Tree;

public class FigTreePDF {
    public static final String VERSION = "1.4.1";
    public static final String DATES = "2006-2014";

    public static void createGraphic(int n, int n2, String string, String string2) {
        try {
            Object object;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string3 = bufferedReader.readLine();
            while (string3 != null && string3.length() == 0) {
                string3 = bufferedReader.readLine();
            }
            bufferedReader.close();
            boolean bl = string3 != null && string3.toUpperCase().contains("#NEXUS");
            FileReader fileReader = new FileReader(string);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            ExtendedTreeViewer extendedTreeViewer = new ExtendedTreeViewer();
            BasicControlPalette basicControlPalette = new BasicControlPalette(200, BasicControlPalette.DisplayMode.ONLY_ONE_OPEN);
            FigTreePanel figTreePanel = new FigTreePanel(null, extendedTreeViewer, basicControlPalette);
            basicControlPalette.getSettings(hashMap);
            ArrayList<Tree> arrayList = new ArrayList<Tree>();
            if (bl) {
                object = new FigTreeNexusImporter(fileReader);
                arrayList.add(((NexusImporter)object).importNextTree());
                try {
                    while (true) {
                        ((NexusImporter)object).findNextBlock();
                        if (!((NexusImporter)object).getNextBlockName().equalsIgnoreCase("FIGTREE")) continue;
                        ((FigTreeNexusImporter)object).parseFigTreeBlock(hashMap);
                    }
                }
                catch (EOFException eOFException) {}
            } else {
                object = new NewickImporter(fileReader, true);
                arrayList.add(((NewickImporter)object).importNextTree());
            }
            if (arrayList.size() == 0) {
                throw new ImportException("This file contained no trees.");
            }
            extendedTreeViewer.setTrees(arrayList);
            basicControlPalette.setSettings(hashMap);
            extendedTreeViewer.getContentPane().setSize(n, n2);
            object = string2 != null ? new FileOutputStream(string2) : System.out;
            Document document = new Document();
            document.setPageSize(new Rectangle(n, n2));
            try {
                PdfWriter pdfWriter = PdfWriter.getInstance(document, (OutputStream)object);
                document.open();
                PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
                PdfTemplate pdfTemplate = pdfContentByte.createTemplate(n, n2);
                Graphics2D graphics2D = pdfTemplate.createGraphics(n, n2);
                pdfTemplate.setWidth(n);
                pdfTemplate.setHeight(n2);
                extendedTreeViewer.getContentPane().print(graphics2D);
                graphics2D.dispose();
                pdfTemplate.sanityCheck();
                pdfContentByte.addTemplate(pdfTemplate, 0.0f, 0.0f);
                pdfContentByte.sanityCheck();
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
            document.close();
        }
        catch (ImportException importException) {
            throw new RuntimeException("Error writing graphic file: " + importException);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error writing graphic file: " + iOException);
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2;
        Arguments arguments = new Arguments(new Arguments.Option[]{new Arguments.IntegerOption("width", "the width of the graphic in pixels"), new Arguments.IntegerOption("height", "the height of the graphic in pixels")});
        try {
            arguments.parseArguments(stringArray);
        }
        catch (Arguments.ArgumentException argumentException) {
            System.out.println();
            System.out.println(argumentException.getMessage());
            System.out.println();
            System.exit(1);
        }
        int n = 800;
        int n2 = 600;
        if (arguments.hasOption("width")) {
            n = arguments.getIntegerOption("width");
        }
        if (arguments.hasOption("height")) {
            n2 = arguments.getIntegerOption("height");
        }
        if ((stringArray2 = arguments.getLeftoverArguments()).length == 0) {
            System.exit(0);
        } else if (stringArray2.length == 1) {
            FigTreePDF.createGraphic(n, n2, stringArray2[0], stringArray2.length > 1 ? stringArray2[1] : null);
            System.exit(0);
        } else {
            FigTreePDF.createGraphic(n, n2, stringArray2[0], stringArray2.length > 1 ? stringArray2[1] : null);
            System.exit(0);
        }
    }
}

