/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.pdf.crypto.AESCipher;
import com.itextpdf.text.pdf.crypto.ARCFOUREncryption;
import com.itextpdf.text.pdf.crypto.IVGenerator;
import java.io.IOException;
import java.io.OutputStream;

public class OutputStreamEncryption
extends OutputStream {
    protected OutputStream out;
    protected ARCFOUREncryption arcfour;
    protected AESCipher cipher;
    private byte[] sb = new byte[1];
    private static final int AES_128 = 4;
    private boolean aes;
    private boolean finished;

    public OutputStreamEncryption(OutputStream outputStream, byte[] byArray, int n, int n2, int n3) {
        try {
            this.out = outputStream;
            boolean bl = this.aes = n3 == 4;
            if (this.aes) {
                byte[] byArray2 = IVGenerator.getIV();
                byte[] byArray3 = new byte[n2];
                System.arraycopy(byArray, n, byArray3, 0, n2);
                this.cipher = new AESCipher(true, byArray3, byArray2);
                this.write(byArray2);
            } else {
                this.arcfour = new ARCFOUREncryption();
                this.arcfour.prepareARCFOURKey(byArray, n, n2);
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public OutputStreamEncryption(OutputStream outputStream, byte[] byArray, int n) {
        this(outputStream, byArray, 0, byArray.length, n);
    }

    public void close() throws IOException {
        this.finish();
        this.out.close();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(int n) throws IOException {
        this.sb[0] = (byte)n;
        this.write(this.sb, 0, 1);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.aes) {
            byte[] byArray2 = this.cipher.update(byArray, n, n2);
            if (byArray2 == null || byArray2.length == 0) {
                return;
            }
            this.out.write(byArray2, 0, byArray2.length);
        } else {
            byte[] byArray3 = new byte[Math.min(n2, 4192)];
            while (n2 > 0) {
                int n3 = Math.min(n2, byArray3.length);
                this.arcfour.encryptARCFOUR(byArray, n, n3, byArray3, 0);
                this.out.write(byArray3, 0, n3);
                n2 -= n3;
                n += n3;
            }
        }
    }

    public void finish() throws IOException {
        if (!this.finished) {
            this.finished = true;
            if (this.aes) {
                byte[] byArray;
                try {
                    byArray = this.cipher.doFinal();
                }
                catch (Exception exception) {
                    throw new ExceptionConverter(exception);
                }
                this.out.write(byArray, 0, byArray.length);
            }
        }
    }
}

